/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.entity;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceInfo;
import javax.persistence.spi.PersistenceProvider;
import javax.sql.DataSource;
import org.hibernate.ejb.HibernatePersistence;
import org.hibernate.ejb.packaging.PersistenceMetadata;
import org.hibernate.ejb.packaging.PersistenceXmlLoader;
import org.jboss.ejb3.DeploymentUnit;
import org.jboss.ejb3.NonSerializableFactory;
import org.jboss.ejb3.entity.InjectedEntityManager;
import org.jboss.ejb3.entity.InjectedEntityManagerFactory;
import org.jboss.ejb3.entity.ManagedEntityManagerFactory;
import org.jboss.ejb3.entity.PersistenceInfoImpl;
import org.jboss.logging.Logger;
import org.jboss.naming.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityManagerDeployment {
    private static final Logger log = Logger.getLogger(EntityManagerDeployment.class);
    protected InitialContext initialContext;
    protected DeploymentUnit di;
    protected List<String> explicitEntityClasses = new ArrayList<String>();
    protected ManagedEntityManagerFactory managedFactory;
    protected EntityManagerFactory actualFactory;
    protected String managedFactoryJndiName;
    protected URL persistenceXmlUrl;
    protected PersistenceMetadata xml;
    protected String kernelName;
    protected boolean scoped;
    protected String scopeName = "";
    public static final String INJECTED_ENTITY_MANAGER_CONTEXT = "EntityManagers";
    public static final String INJECTED_ENTITY_MANAGER_FACTORY_CONTEXT = "EntityManagerFactories";
    public static final String ACTUAL_ENTITY_MANAGER_FACTORY_CONTEXT = "ActualEntityManagerFactories";
    public static final String MANAGED_ENTITY_FACTORY_CONTEXT = "managedEntityFactories";
    public static final String EMPTY_STRING = "EMPTYSTRING";
    protected String baseJndiName;

    public EntityManagerDeployment(InitialContext initialContext, DeploymentUnit di, List<String> explicitEntityClasses, URL persistenceXmlUrl, String scopeName) {
        this.initialContext = initialContext;
        this.di = di;
        this.explicitEntityClasses = explicitEntityClasses;
        this.persistenceXmlUrl = persistenceXmlUrl;
        if (persistenceXmlUrl != null) {
            try {
                this.xml = PersistenceXmlLoader.deploy((URL)persistenceXmlUrl);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (scopeName != null) {
            this.scopeName = scopeName;
            this.scoped = true;
            String name = this.getEntityManagerName();
            if (name == null || name.equals("")) {
                name = EMPTY_STRING;
            }
            this.kernelName = "entity.manager:scope=" + scopeName + ",name=" + name;
        } else {
            this.kernelName = EntityManagerDeployment.getGlobalEntityManagerKernelName(this.getEntityManagerName());
        }
    }

    protected String getJaccContextId() {
        return this.di.getShortName();
    }

    public EntityManagerFactory getActualFactory() {
        return this.actualFactory;
    }

    public PersistenceMetadata getXml() {
        return this.xml;
    }

    public String getKernelName() {
        return this.kernelName;
    }

    public String getEntityManagerName() {
        return this.xml.getName() == null ? "" : this.xml.getName();
    }

    public ManagedEntityManagerFactory getManagedFactory() {
        return this.managedFactory;
    }

    public String getManagedFactoryJndiName() {
        return this.managedFactoryJndiName;
    }

    public static String getGlobalEntityManagerKernelName(String name) {
        if (name == null || name.equals("")) {
            name = EMPTY_STRING;
        }
        return "entity.manager:name=" + name;
    }

    public void start() throws Exception {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.di.getDefaultPersistenceProperties());
        props.put("hibernate.jacc.ctx.id", this.getJaccContextId());
        PersistenceInfoImpl pi = new PersistenceInfoImpl();
        pi.setClassLoader(this.di.getClassLoader());
        ArrayList<URL> jarFiles = new ArrayList<URL>();
        pi.setJarFiles(jarFiles);
        pi.setPersistenceProviderClassName(HibernatePersistence.class.getName());
        if (this.persistenceXmlUrl != null) {
            log.info((Object)"Found persistence.xml file in EJB3 jar");
            props.putAll((Map<?, ?>)this.xml.getProps());
            pi.setEntityclassNames(this.xml.getClasses());
            pi.setEntityManagerName(this.xml.getName());
            pi.setPersistenceXmlFileUrl(this.persistenceXmlUrl);
            pi.setMappingFileNames(this.xml.getMappingFiles());
            for (String jar : this.xml.getJarFiles()) {
                URL url = null;
                try {
                    url = new URL(jar);
                }
                catch (MalformedURLException e) {
                    if (jar.startsWith("..")) {
                        if (this.di.getUrl() == null) {
                            throw new RuntimeException("relative <jar-file> not allowed when standalone deployment unit is used");
                        }
                        String base = this.di.getUrl().toString();
                        jar = jar.replaceAll("\\.\\./", "+");
                        int idx = jar.lastIndexOf(43);
                        jar = jar.substring(idx + 1);
                        for (int i = 0; i < idx + 1; ++i) {
                            int slash = base.lastIndexOf(47);
                            base = base.substring(0, slash + 1);
                        }
                        url = new URL(base + jar.substring(idx));
                    }
                    File fp = new File(jar);
                    url = fp.toURL();
                }
                log.info((Object)("adding JarFile URL: " + url.toString()));
                jarFiles.add(url);
            }
            if (this.xml.getJtaDatasource() != null) {
                props.setProperty("hibernate.connection.datasource", this.xml.getJtaDatasource());
            }
            if (this.xml.getProvider() != null) {
                pi.setPersistenceProviderClassName(this.xml.getProvider());
            }
        }
        if (this.explicitEntityClasses.size() > 0) {
            List<String> classes = pi.getEntityclassNames();
            if (classes == null) {
                classes = this.explicitEntityClasses;
            } else {
                classes.addAll(this.explicitEntityClasses);
            }
            pi.setEntityclassNames(classes);
        }
        String jtaDatasource = props.getProperty("hibernate.connection.datasource");
        props.remove("hibernate.connection.datasource");
        pi.setJtaDataSource((DataSource)this.initialContext.lookup(jtaDatasource));
        pi.setProperties(props);
        if (this.di.getUrl() != null) {
            jarFiles.add(this.di.getUrl());
        }
        if (pi.getEntityManagerName() == null) {
            String name = EMPTY_STRING;
            pi.setEntityManagerName(name);
            log.info((Object)("empty string entity manager name: " + name));
        }
        this.managedFactoryJndiName = pi.getEntityManagerName();
        Class<?> providerClass = Thread.currentThread().getContextClassLoader().loadClass(pi.getPersistenceProviderClassName());
        PersistenceProvider pp = (PersistenceProvider)providerClass.newInstance();
        this.actualFactory = pp.createContainerEntityManagerFactory((PersistenceInfo)pi);
        Context actualCtx = null;
        Context managersCtx = null;
        Context factoryCtx = null;
        Context managedFactoryCtx = null;
        this.baseJndiName = "java:/";
        if (this.scoped) {
            this.baseJndiName = "java:/scopedEntityManagers/" + this.scopeName + "/";
        }
        actualCtx = Util.createSubcontext((Context)this.initialContext, (String)(this.baseJndiName + ACTUAL_ENTITY_MANAGER_FACTORY_CONTEXT));
        managersCtx = Util.createSubcontext((Context)this.initialContext, (String)(this.baseJndiName + INJECTED_ENTITY_MANAGER_CONTEXT));
        factoryCtx = Util.createSubcontext((Context)this.initialContext, (String)(this.baseJndiName + INJECTED_ENTITY_MANAGER_FACTORY_CONTEXT));
        managedFactoryCtx = Util.createSubcontext((Context)this.initialContext, (String)(this.baseJndiName + MANAGED_ENTITY_FACTORY_CONTEXT));
        log.info((Object)("Create EntityManager with JNDI name: " + this.managedFactoryJndiName));
        this.managedFactory = new ManagedEntityManagerFactory(this.actualFactory, this.baseJndiName + MANAGED_ENTITY_FACTORY_CONTEXT + "/" + this.managedFactoryJndiName);
        NonSerializableFactory.bind(managedFactoryCtx, this.managedFactoryJndiName, this.managedFactory);
        NonSerializableFactory.bind(actualCtx, this.managedFactoryJndiName, this.actualFactory);
        InjectedEntityManager injectedManager = new InjectedEntityManager(this.managedFactory, this.di.getJndiProperties());
        NonSerializableFactory.bind(managersCtx, this.managedFactoryJndiName, injectedManager);
        InjectedEntityManagerFactory injectedFactory = new InjectedEntityManagerFactory(this.actualFactory, this.baseJndiName + ACTUAL_ENTITY_MANAGER_FACTORY_CONTEXT + "/" + this.managedFactoryJndiName, this.di.getJndiProperties());
        NonSerializableFactory.bind(factoryCtx, this.managedFactoryJndiName, injectedFactory);
    }

    public String getScopedActualJndiName() {
        return this.baseJndiName + ACTUAL_ENTITY_MANAGER_FACTORY_CONTEXT + "/" + this.managedFactoryJndiName;
    }

    public static String getManagedEntityFactoryJndiName(String unitName) {
        String name = unitName.equals("") ? EMPTY_STRING : unitName;
        return "java:/managedEntityFactories/" + name;
    }

    public static String getActualEntityManagerFactoryJndiName(String unitName) {
        String name = unitName.equals("") ? EMPTY_STRING : unitName;
        return "java:/ActualEntityManagerFactories/" + name;
    }

    public void stop() throws Exception {
        Context actualCtx = null;
        Context managersCtx = null;
        Context factoryCtx = null;
        Context managedFactoryCtx = null;
        actualCtx = Util.createSubcontext((Context)this.initialContext, (String)(this.baseJndiName + ACTUAL_ENTITY_MANAGER_FACTORY_CONTEXT));
        managersCtx = Util.createSubcontext((Context)this.initialContext, (String)(this.baseJndiName + INJECTED_ENTITY_MANAGER_CONTEXT));
        factoryCtx = Util.createSubcontext((Context)this.initialContext, (String)(this.baseJndiName + INJECTED_ENTITY_MANAGER_FACTORY_CONTEXT));
        managedFactoryCtx = Util.createSubcontext((Context)this.initialContext, (String)(this.baseJndiName + MANAGED_ENTITY_FACTORY_CONTEXT));
        NonSerializableFactory.unbind(managedFactoryCtx, this.managedFactoryJndiName);
        NonSerializableFactory.unbind(actualCtx, this.managedFactoryJndiName);
        NonSerializableFactory.unbind(managersCtx, this.managedFactoryJndiName);
        NonSerializableFactory.unbind(factoryCtx, this.managedFactoryJndiName);
        this.managedFactory.destroy();
    }
}

