/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.embedded;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.management.ObjectName;
import javax.security.jacc.PolicyConfiguration;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.DependencyPolicy;
import org.jboss.ejb3.DeploymentUnit;
import org.jboss.ejb3.Ejb3Deployment;
import org.jboss.ejb3.MCDependencyPolicy;
import org.jboss.ejb3.security.JaccHelper;
import org.jboss.ejb3.service.ServiceContainer;
import org.jboss.ejb3.service.ServiceManager;

public class EJB3StandaloneDeployment
extends Ejb3Deployment {
    public EJB3StandaloneDeployment(DeploymentUnit di) {
        super(di);
        this.defaultSFSBDomain = "Embedded Stateful Bean";
    }

    protected void initializeJacc(PolicyConfiguration pc, DeploymentUnit unit) {
        try {
            pc.commit();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected PolicyConfiguration createPolicyConfiguration() throws Exception {
        return JaccHelper.initialiseJacc(this.getJaccContextId());
    }

    protected Map getDefaultPersistenceProperties() {
        try {
            Properties hb = new Properties();
            InputStream hbstream = this.di.getResourceLoader().getResourceAsStream("default.persistence.properties");
            hb.load(hbstream);
            hbstream.close();
            return hb;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void registerContainer(Container container) throws Exception {
        super.registerContainer(container);
        container.create();
    }

    public void start() throws Exception {
        try {
            System.out.println("!!EjbStandalonedeployment start");
            super.start();
            ArrayList<Container> serviceBeans = new ArrayList<Container>();
            Iterator it = this.containers.keySet().iterator();
            System.out.println("!!  serviceBeans " + serviceBeans.size());
            while (it.hasNext()) {
                ObjectName on = (ObjectName)it.next();
                Container con = (Container)this.containers.get(on);
                System.out.println("!!   container " + con.getEjbName() + " " + con.getClass().getName());
                if (con instanceof ServiceManager || con instanceof ServiceContainer) {
                    serviceBeans.add(con);
                    continue;
                }
                con.start();
            }
            for (Container con : serviceBeans) {
                con.start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void stop() throws Exception {
        for (ObjectName on : this.containers.keySet()) {
            Container con = (Container)this.containers.get(on);
            con.stop();
        }
        super.stop();
    }

    public void destroy() throws Exception {
        super.destroy();
        for (ObjectName on : this.containers.keySet()) {
            Container con = (Container)this.containers.get(on);
            con.destroy();
        }
    }

    protected void startEntityManagerDeployment() {
        if (this.entityDeployment != null) {
            try {
                this.entityDeployment.start();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void stopEntityManagerDeployment() {
        if (this.entityDeployment != null) {
            try {
                this.entityDeployment.stop();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public DependencyPolicy createDependencyPolicy() {
        return new MCDependencyPolicy();
    }
}

