/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3;

import java.io.Externalizable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.SessionSynchronization;
import javax.ejb.TimedObject;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.jboss.annotation.ejb.LocalBinding;
import org.jboss.annotation.ejb.RemoteBinding;
import org.jboss.annotation.ejb.RemoteBindings;
import org.jboss.aop.Advisor;
import org.jboss.ejb.LocalImpl;
import org.jboss.ejb.RemoteImpl;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.EJBContainer;
import org.jboss.logging.Logger;

public class ProxyFactoryHelper {
    private static final Logger log = Logger.getLogger(ProxyFactoryHelper.class);

    public static Context getProxyFactoryContext(Context ctx) throws NamingException {
        try {
            return (Context)ctx.lookup("proxyFactory");
        }
        catch (NameNotFoundException e) {
            return ctx.createSubcontext("proxyFactory");
        }
    }

    public static Class[] getLocalInterfaces(Container container) {
        Class beanClass = container.getBeanClass();
        Local li = (Local)((EJBContainer)container).resolveAnnotation(Local.class);
        Class[] ri = ProxyFactoryHelper.getRemoteInterfaces(container);
        if (li == null && ri == null && (beanClass.getInterfaces() == null || beanClass.getInterfaces().length == 0)) {
            throw new RuntimeException("bean class has no local or remote interfaces defined and does not implement at least one business interface");
        }
        if (li == null) {
            Class[] intfs = beanClass.getInterfaces();
            ArrayList locals = new ArrayList();
            for (Class<?> clazz : intfs) {
                if (!clazz.isAnnotationPresent(Local.class)) continue;
                locals.add(clazz);
            }
            if (locals.size() > 0) {
                intfs = locals.toArray(new Class[locals.size()]);
                li = new LocalImpl(intfs);
                ((Advisor)container).getAnnotations().addClassAnnotation(Local.class, (Object)li);
                return li.value();
            }
        }
        if (li == null) {
            if (ri == null) {
                ArrayList interfaces = new ArrayList(Arrays.asList(beanClass.getInterfaces()));
                interfaces.remove(Serializable.class);
                interfaces.remove(Externalizable.class);
                interfaces.remove(SessionSynchronization.class);
                interfaces.remove(TimedObject.class);
                if (interfaces.size() == 0) {
                    throw new RuntimeException("bean class has no local or remote interfaces defined and does not implement at least one business interface");
                }
                if (interfaces.size() > 1) {
                    throw new RuntimeException("deployer cannot determine default local interface as there are too many implemented interfaces and no @Remote or @Local defined");
                }
                Class[] rtn = new Class[]{interfaces.get(0)};
                li = new LocalImpl(rtn);
                ((EJBContainer)container).getAnnotations().addClassAnnotation(Local.class, (Object)li);
                return rtn;
            }
            return null;
        }
        return li.value();
    }

    public static String getJndiName(Container container, Class businessInterface) {
        Advisor advisor = (Advisor)container;
        Class[] remotes = ProxyFactoryHelper.getRemoteInterfaces(container);
        if (remotes != null) {
            for (Class clazz : remotes) {
                if (!clazz.getName().equals(businessInterface.getName())) continue;
                RemoteBindings bindings = (RemoteBindings)advisor.resolveAnnotation(RemoteBindings.class);
                if (bindings == null) {
                    RemoteBinding binding = (RemoteBinding)advisor.resolveAnnotation(RemoteBinding.class);
                    if (binding == null) {
                        throw new RuntimeException("RemoteBindings should not be null: " + container.getEjbName());
                    }
                    return ProxyFactoryHelper.getRemoteJndiName(container, binding);
                }
                return ProxyFactoryHelper.getRemoteJndiName(container, bindings.value()[0]);
            }
        }
        return ProxyFactoryHelper.getLocalJndiName(container);
    }

    public static String getLocalJndiName(Container container) {
        Advisor advisor = (Advisor)container;
        LocalBinding localBinding = (LocalBinding)advisor.resolveAnnotation(LocalBinding.class);
        if (localBinding == null) {
            Class[] interfaces = ProxyFactoryHelper.getLocalInterfaces(container);
            if (interfaces.length == 1) {
                return interfaces[0].getName();
            }
            return container.getEjbName();
        }
        return localBinding.jndiBinding();
    }

    public static Class[] getRemoteInterfaces(Container container) {
        Remote ri = (Remote)((Advisor)container).resolveAnnotation(Remote.class);
        if (ri == null) {
            Class beanClass = container.getBeanClass();
            Class[] intfs = beanClass.getInterfaces();
            ArrayList remotes = new ArrayList();
            for (Class<?> clazz : intfs) {
                if (!clazz.isAnnotationPresent(Remote.class)) continue;
                remotes.add(clazz);
            }
            if (remotes.size() > 0) {
                intfs = remotes.toArray(new Class[remotes.size()]);
                ri = new RemoteImpl(intfs);
                ((Advisor)container).getAnnotations().addClassAnnotation(Remote.class, (Object)ri);
                return ri.value();
            }
            return null;
        }
        return ri.value();
    }

    public static String getRemoteJndiName(Container container) {
        Advisor advisor = (Advisor)container;
        RemoteBinding binding = (RemoteBinding)advisor.resolveAnnotation(RemoteBinding.class);
        return ProxyFactoryHelper.getRemoteJndiName(container, binding);
    }

    public static String getRemoteJndiName(Container container, RemoteBinding binding) {
        String jndiName = null;
        jndiName = binding == null || binding.jndiBinding() == null || binding.jndiBinding().equals("") ? ProxyFactoryHelper.getDefaultRemoteJndiName(container) : binding.jndiBinding();
        return jndiName;
    }

    public static String getDefaultRemoteJndiName(Container container) {
        String jndiName = null;
        Class[] interfaces = ProxyFactoryHelper.getRemoteInterfaces(container);
        jndiName = interfaces.length == 1 ? interfaces[0].getName() : container.getEjbName();
        return jndiName;
    }
}

