/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3;

import java.util.ArrayList;
import org.jboss.annotation.ejb.Clustered;
import org.jboss.annotation.ejb.LocalBinding;
import org.jboss.annotation.ejb.LocalBindingImpl;
import org.jboss.annotation.ejb.RemoteBinding;
import org.jboss.annotation.ejb.RemoteBindingImpl;
import org.jboss.annotation.ejb.RemoteBindings;
import org.jboss.annotation.ejb.RemoteBindingsImpl;
import org.jboss.aop.Advisor;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.ProxyFactory;
import org.jboss.ejb3.ProxyFactoryHelper;
import org.jboss.ejb3.remoting.RemoteProxyFactory;
import org.jboss.ejb3.service.ServiceContainer;
import org.jboss.ejb3.service.ServiceLocalProxyFactory;
import org.jboss.ejb3.service.ServiceRemoteProxyFactory;
import org.jboss.ejb3.stateful.StatefulClusterProxyFactory;
import org.jboss.ejb3.stateful.StatefulContainer;
import org.jboss.ejb3.stateful.StatefulLocalProxyFactory;
import org.jboss.ejb3.stateful.StatefulRemoteProxyFactory;
import org.jboss.ejb3.stateless.StatelessClusterProxyFactory;
import org.jboss.ejb3.stateless.StatelessLocalProxyFactory;
import org.jboss.ejb3.stateless.StatelessRemoteProxyFactory;
import org.jboss.logging.Logger;

public class ProxyDeployer {
    private static final Logger log = Logger.getLogger(ProxyDeployer.class);
    private Container container;
    private Advisor advisor;
    private ArrayList proxyFactories = new ArrayList();
    private String defaultClientBinding = "socket://0.0.0.0:3873";

    public ProxyDeployer(Container container) {
        this.container = container;
        this.advisor = (Advisor)container;
    }

    public void setDefaultClientBinding(String defaultClientBinding) {
        this.defaultClientBinding = defaultClientBinding;
    }

    public void start() throws Exception {
        LocalBinding localBinding;
        Object factory;
        RemoteBindings bindings = (RemoteBindings)this.advisor.resolveAnnotation(RemoteBindings.class);
        if (bindings == null) {
            RemoteBinding binding = (RemoteBinding)this.advisor.resolveAnnotation(RemoteBinding.class);
            if (binding == null) {
                log.info((Object)("no declared remote bindings for : " + this.container.getEjbName()));
                if (ProxyFactoryHelper.getRemoteInterfaces(this.container) != null) {
                    log.info((Object)("there is remote interfaces for " + this.container.getEjbName()));
                    String jndiName = ProxyFactoryHelper.getDefaultRemoteJndiName(this.container);
                    log.info((Object)("default remote binding has jndiName of " + jndiName));
                    String uri = this.defaultClientBinding;
                    factory = null;
                    factory = this.getDefaultRemoteProxyFactory();
                    RemoteBinding[] list = new RemoteBinding[]{new RemoteBindingImpl(jndiName, "", uri, (Class)factory)};
                    bindings = new RemoteBindingsImpl(list);
                    this.advisor.getAnnotations().addClassAnnotation(RemoteBindings.class, (Object)bindings);
                }
            } else {
                RemoteBinding[] list = new RemoteBinding[]{binding};
                bindings = new RemoteBindingsImpl(list);
                this.advisor.getAnnotations().addClassAnnotation(RemoteBindings.class, (Object)bindings);
            }
        }
        if (bindings != null) {
            RemoteBinding[] list = bindings.value();
            for (int i = 0; i < list.length; ++i) {
                Class factoryClass = list[i].factory();
                if (factoryClass.equals(RemoteProxyFactory.class)) {
                    factoryClass = this.getDefaultRemoteProxyFactory();
                }
                factory = (RemoteProxyFactory)factoryClass.newInstance();
                factory.setRemoteBinding(list[i]);
                factory.setContainer(this.container);
                factory.start();
                this.proxyFactories.add(factory);
            }
        }
        if ((localBinding = (LocalBinding)this.advisor.resolveAnnotation(LocalBinding.class)) == null && ProxyFactoryHelper.getLocalInterfaces(this.container) != null) {
            localBinding = new LocalBindingImpl(ProxyFactoryHelper.getLocalJndiName(this.container));
            this.advisor.getAnnotations().addClassAnnotation(LocalBinding.class, (Object)localBinding);
        }
        if (localBinding != null) {
            ProxyFactory factory2 = null;
            factory2 = this.container instanceof StatefulContainer ? new StatefulLocalProxyFactory() : (this.container instanceof ServiceContainer ? new ServiceLocalProxyFactory() : new StatelessLocalProxyFactory());
            factory2.setContainer(this.container);
            factory2.start();
            this.proxyFactories.add(factory2);
        }
    }

    private Class getDefaultRemoteProxyFactory() {
        Class factory = this.container instanceof StatefulContainer ? (this.advisor.resolveAnnotation(Clustered.class) != null ? StatefulClusterProxyFactory.class : StatefulRemoteProxyFactory.class) : (this.container instanceof ServiceContainer ? ServiceRemoteProxyFactory.class : (this.advisor.resolveAnnotation(Clustered.class) != null ? StatelessClusterProxyFactory.class : StatelessRemoteProxyFactory.class));
        return factory;
    }

    public void stop() throws Exception {
        for (int i = 0; i < this.proxyFactories.size(); ++i) {
            ProxyFactory factory = (ProxyFactory)this.proxyFactories.get(i);
            factory.stop();
        }
    }
}

