/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import org.codehaus.janino.Java;
import org.codehaus.janino.Mod;
import org.codehaus.janino.Parser;
import org.codehaus.janino.Scanner;
import org.codehaus.janino.Visitor;
import org.codehaus.janino.util.AutoIndentWriter;

public class UnparseVisitor
implements Visitor.ComprehensiveVisitor {
    private final AutoIndentWriter aiw;
    private final PrintWriter pw;

    public UnparseVisitor(Writer writer) {
        this.aiw = new AutoIndentWriter(writer);
        this.pw = new PrintWriter((Writer)this.aiw, true);
    }

    public static void main(String[] stringArray) throws Exception {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(System.out));
        int n = 0;
        while (n < stringArray.length) {
            Java.CompilationUnit compilationUnit;
            String string = stringArray[n];
            FileReader fileReader = new FileReader(string);
            try {
                compilationUnit = new Parser(new Scanner(string, fileReader)).parseCompilationUnit();
            }
            finally {
                Object var7_6 = null;
                fileReader.close();
            }
            UnparseVisitor.unparse(compilationUnit, bufferedWriter);
            ++n;
        }
        ((Writer)bufferedWriter).flush();
    }

    public static void unparse(Java.CompilationUnit compilationUnit, Writer writer) {
        new UnparseVisitor(writer).unparseCompilationUnit(compilationUnit);
    }

    private void unparseAbstractTypeDeclarationBody(Java.AbstractTypeDeclaration abstractTypeDeclaration) {
        Iterator iterator = abstractTypeDeclaration.declaredMethods.iterator();
        while (iterator.hasNext()) {
            ((Java.MethodDeclarator)iterator.next()).accept(this);
            this.pw.println();
        }
        Iterator iterator2 = abstractTypeDeclaration.declaredClassesAndInterfaces.iterator();
        while (iterator2.hasNext()) {
            ((Java.TypeBodyDeclaration)iterator2.next()).accept(this);
            this.pw.println();
        }
    }

    private void unparseArrayInitializerOrRvalue(Java.ArrayInitializerOrRvalue arrayInitializerOrRvalue) {
        if (arrayInitializerOrRvalue instanceof Java.Rvalue) {
            ((Java.Atom)((Object)arrayInitializerOrRvalue)).accept(this);
        } else if (arrayInitializerOrRvalue instanceof Java.ArrayInitializer) {
            Java.ArrayInitializer arrayInitializer = (Java.ArrayInitializer)arrayInitializerOrRvalue;
            if (arrayInitializer.values.length == 0) {
                this.pw.print("{}");
            } else {
                this.pw.print("{ ");
                this.unparseArrayInitializerOrRvalue(arrayInitializer.values[0]);
                int n = 1;
                while (n < arrayInitializer.values.length) {
                    this.pw.print(", ");
                    this.unparseArrayInitializerOrRvalue(arrayInitializer.values[n]);
                    ++n;
                }
                this.pw.print(" }");
            }
        } else {
            throw new RuntimeException("Unexpected array initializer or rvalue class " + arrayInitializerOrRvalue.getClass().getName());
        }
    }

    private void unparseClassDeclarationBody(Java.ClassDeclaration classDeclaration) {
        Iterator iterator = classDeclaration.constructors.iterator();
        while (iterator.hasNext()) {
            ((Java.ConstructorDeclarator)iterator.next()).accept(this);
            this.pw.println();
        }
        this.unparseAbstractTypeDeclarationBody(classDeclaration);
        Iterator iterator2 = classDeclaration.variableDeclaratorsAndInitializers.iterator();
        while (iterator2.hasNext()) {
            ((Java.TypeBodyDeclaration)iterator2.next()).accept(this);
            this.pw.println();
        }
    }

    public void unparseCompilationUnit(Java.CompilationUnit compilationUnit) {
        if (compilationUnit.optionalPackageDeclaration != null) {
            this.pw.println("package " + compilationUnit.optionalPackageDeclaration.packageName + ';');
        }
        Iterator iterator = compilationUnit.importDeclarations.iterator();
        while (iterator.hasNext()) {
            ((Java.CompilationUnit.ImportDeclaration)iterator.next()).accept(this);
        }
        Iterator iterator2 = compilationUnit.packageMemberTypeDeclarations.iterator();
        while (iterator2.hasNext()) {
            ((Java.PackageMemberTypeDeclaration)iterator2.next()).accept(this);
            this.pw.println();
        }
    }

    private void unparseDocComment(Java.DocCommentable docCommentable) {
        String string = docCommentable.getDocComment();
        if (string != null) {
            this.pw.println();
            this.pw.print("/**");
            this.aiw.setPrefix(" *");
            try {
                this.pw.print(string);
            }
            finally {
                Object var4_3 = null;
                this.aiw.setPrefix(null);
            }
            this.pw.println(" */");
        }
    }

    public void unparseFormalParameter(Java.FunctionDeclarator.FormalParameter formalParameter) {
        if (formalParameter.finaL) {
            this.pw.print("final ");
        }
        formalParameter.type.accept(this);
        this.pw.print(String.valueOf(' ') + formalParameter.name);
    }

    private void unparseFunctionDeclaratorRest(Java.FunctionDeclarator functionDeclarator) {
        this.pw.print('(');
        int n = 0;
        while (n < functionDeclarator.formalParameters.length) {
            if (n > 0) {
                this.pw.print(", ");
            }
            this.unparseFormalParameter(functionDeclarator.formalParameters[n]);
            ++n;
        }
        this.pw.print(')');
        if (functionDeclarator.thrownExceptions.length > 0) {
            this.pw.print(" throws " + Java.join(functionDeclarator.thrownExceptions, ", "));
        }
    }

    private void unparseFunctionInvocationArguments(Java.Rvalue[] rvalueArray) {
        this.pw.print('(');
        int n = 0;
        while (n < rvalueArray.length) {
            if (n > 0) {
                this.pw.print(", ");
            }
            rvalueArray[n].accept(this);
            ++n;
        }
        this.pw.print(')');
    }

    private void unparseInterfaceDeclaration(Java.InterfaceDeclaration interfaceDeclaration) {
        this.unparseDocComment(interfaceDeclaration);
        this.unparseModifiers(interfaceDeclaration.modifiers);
        this.pw.print("interface " + interfaceDeclaration.name);
        if (interfaceDeclaration.extendedTypes.length > 0) {
            this.pw.print(" extends " + Java.join(interfaceDeclaration.extendedTypes, ", "));
        }
        this.pw.println(" {");
        this.unparseAbstractTypeDeclarationBody(interfaceDeclaration);
        Iterator iterator = interfaceDeclaration.constantDeclarations.iterator();
        while (iterator.hasNext()) {
            ((Java.TypeBodyDeclaration)iterator.next()).accept(this);
            this.pw.println();
        }
        this.pw.print('}');
    }

    private void unparseModifiers(short s) {
        if (s != 0) {
            this.pw.print(String.valueOf(Mod.shortToString(s)) + ' ');
        }
    }

    private void unparseNamedClassDeclaration(Java.NamedClassDeclaration namedClassDeclaration) {
        this.unparseDocComment(namedClassDeclaration);
        this.unparseModifiers(namedClassDeclaration.modifiers);
        this.pw.print("class " + namedClassDeclaration.name);
        if (namedClassDeclaration.optionalExtendedType != null) {
            this.pw.print(" extends ");
            namedClassDeclaration.optionalExtendedType.accept(this);
        }
        if (namedClassDeclaration.implementedTypes.length > 0) {
            this.pw.print(" implements " + Java.join(namedClassDeclaration.implementedTypes, ", "));
        }
        this.pw.println(" {");
        this.unparseClassDeclarationBody(namedClassDeclaration);
        this.pw.print('}');
    }

    public void unparseVariableDeclarator(Java.VariableDeclarator variableDeclarator) {
        this.pw.print(variableDeclarator.name);
        int n = 0;
        while (n < variableDeclarator.brackets) {
            this.pw.print("[]");
            ++n;
        }
        if (variableDeclarator.optionalInitializer != null) {
            this.pw.print(" = ");
            ((Java.Atom)((Object)variableDeclarator.optionalInitializer)).accept(this);
        }
    }

    public void visitAlternateConstructorInvocation(Java.AlternateConstructorInvocation alternateConstructorInvocation) {
        this.pw.print("this");
        this.unparseFunctionInvocationArguments(alternateConstructorInvocation.arguments);
    }

    public void visitAmbiguousName(Java.AmbiguousName ambiguousName) {
        this.pw.print(ambiguousName.toString());
    }

    public void visitAnonymousClassDeclaration(Java.AnonymousClassDeclaration anonymousClassDeclaration) {
        anonymousClassDeclaration.baseType.accept(this);
        this.pw.println(" {");
        this.unparseClassDeclarationBody(anonymousClassDeclaration);
        this.pw.print('}');
    }

    public void visitArrayAccessExpression(Java.ArrayAccessExpression arrayAccessExpression) {
        arrayAccessExpression.lhs.accept(this);
        this.pw.print('[');
        arrayAccessExpression.index.accept(this);
        this.pw.print(']');
    }

    public void visitArrayLength(Java.ArrayLength arrayLength) {
        arrayLength.lhs.accept(this);
        this.pw.print(".length");
    }

    public void visitArrayType(Java.ArrayType arrayType) {
        arrayType.componentType.accept(this);
        this.pw.print("[]");
    }

    public void visitAssignment(Java.Assignment assignment) {
        assignment.lhs.accept(this);
        this.pw.print(String.valueOf(' ') + assignment.operator + ' ');
        assignment.rhs.accept(this);
    }

    public void visitBasicType(Java.BasicType basicType) {
        this.pw.print(basicType.toString());
    }

    public void visitBinaryOperation(Java.BinaryOperation binaryOperation) {
        binaryOperation.lhs.accept(this);
        this.pw.print(String.valueOf(' ') + binaryOperation.op + ' ');
        binaryOperation.rhs.accept(this);
    }

    public void visitBlock(Java.Block block) {
        this.pw.println('{');
        Iterator iterator = block.statements.iterator();
        while (iterator.hasNext()) {
            ((Java.BlockStatement)iterator.next()).accept(this);
            this.pw.println();
        }
        this.pw.print('}');
    }

    public void visitBreakStatement(Java.BreakStatement breakStatement) {
        this.pw.print("break");
        if (breakStatement.optionalLabel != null) {
            this.pw.print(String.valueOf(' ') + breakStatement.optionalLabel);
        }
        this.pw.print(';');
    }

    public void visitCast(Java.Cast cast) {
        this.pw.print('(');
        cast.targetType.accept(this);
        this.pw.print(") ");
        cast.value.accept(this);
    }

    public void visitClassLiteral(Java.ClassLiteral classLiteral) {
        classLiteral.type.accept(this);
        this.pw.print(".class");
    }

    public void visitConditionalExpression(Java.ConditionalExpression conditionalExpression) {
        conditionalExpression.lhs.accept(this);
        this.pw.print(" ? ");
        conditionalExpression.mhs.accept(this);
        this.pw.print(" : ");
        conditionalExpression.rhs.accept(this);
    }

    public void visitConstantValue(Java.ConstantValue constantValue) {
        this.pw.print(constantValue.toString());
    }

    public void visitConstructorDeclarator(Java.ConstructorDeclarator constructorDeclarator) {
        this.unparseDocComment(constructorDeclarator);
        this.unparseModifiers(constructorDeclarator.modifiers);
        Java.ClassDeclaration classDeclaration = constructorDeclarator.getDeclaringClass();
        this.pw.print(classDeclaration instanceof Java.NamedClassDeclaration ? ((Java.NamedClassDeclaration)classDeclaration).name : "UNNAMED");
        this.unparseFunctionDeclaratorRest(constructorDeclarator);
        this.pw.print(' ');
        if (constructorDeclarator.optionalConstructorInvocation != null) {
            this.pw.println('{');
            constructorDeclarator.optionalConstructorInvocation.accept(this);
            this.pw.println(';');
            Iterator iterator = constructorDeclarator.optionalBody.statements.iterator();
            while (iterator.hasNext()) {
                ((Java.BlockStatement)iterator.next()).accept(this);
                this.pw.println();
            }
            this.pw.print('}');
        } else {
            constructorDeclarator.optionalBody.accept(this);
        }
    }

    public void visitContinueStatement(Java.ContinueStatement continueStatement) {
        this.pw.print("continue");
        if (continueStatement.optionalLabel != null) {
            this.pw.print(String.valueOf(' ') + continueStatement.optionalLabel);
        }
        this.pw.print(';');
    }

    public void visitCrement(Java.Crement crement) {
        this.pw.print(crement.pre ? String.valueOf(crement.operator) + crement.operand : String.valueOf(String.valueOf(crement.operand)) + crement.operator);
    }

    public void visitDoStatement(Java.DoStatement doStatement) {
        this.pw.print("do ");
        doStatement.body.accept(this);
        this.pw.print("while (");
        doStatement.condition.accept(this);
        this.pw.print(");");
    }

    public void visitEmptyStatement(Java.EmptyStatement emptyStatement) {
        this.pw.print(';');
    }

    public void visitExpressionStatement(Java.ExpressionStatement expressionStatement) {
        expressionStatement.rvalue.accept(this);
        this.pw.print(';');
    }

    public void visitFieldAccess(Java.FieldAccess fieldAccess) {
        fieldAccess.lhs.accept(this);
        this.pw.print(String.valueOf('.') + fieldAccess.field.getName());
    }

    public void visitFieldAccessExpression(Java.FieldAccessExpression fieldAccessExpression) {
        fieldAccessExpression.lhs.accept(this);
        this.pw.print(String.valueOf('.') + fieldAccessExpression.fieldName);
    }

    public void visitFieldDeclaration(Java.FieldDeclaration fieldDeclaration) {
        this.unparseDocComment(fieldDeclaration);
        this.unparseModifiers(fieldDeclaration.modifiers);
        fieldDeclaration.type.accept(this);
        this.pw.print(' ');
        int n = 0;
        while (n < fieldDeclaration.variableDeclarators.length) {
            if (n > 0) {
                this.pw.print(", ");
            }
            this.unparseVariableDeclarator(fieldDeclaration.variableDeclarators[n]);
            ++n;
        }
        this.pw.print(';');
    }

    public void visitForStatement(Java.ForStatement forStatement) {
        this.pw.print("for (");
        if (forStatement.optionalInit != null) {
            forStatement.optionalInit.accept(this);
        } else {
            this.pw.print(';');
        }
        if (forStatement.optionalCondition != null) {
            this.pw.print(' ');
            forStatement.optionalCondition.accept(this);
        }
        this.pw.print(';');
        if (forStatement.optionalUpdate != null) {
            this.pw.print(' ');
            int n = 0;
            while (n < forStatement.optionalUpdate.length) {
                if (n > 0) {
                    this.pw.print(", ");
                }
                forStatement.optionalUpdate[n].accept(this);
                ++n;
            }
        }
        this.pw.print(") ");
        forStatement.body.accept(this);
    }

    public void visitIfStatement(Java.IfStatement ifStatement) {
        this.pw.print("if (");
        ifStatement.condition.accept(this);
        this.pw.print(") ");
        ifStatement.thenStatement.accept(this);
        if (ifStatement.optionalElseStatement != null) {
            this.pw.print(" else ");
            ifStatement.optionalElseStatement.accept(this);
        }
    }

    public void visitInitializer(Java.Initializer initializer) {
        if (initializer.statiC) {
            this.pw.print("static ");
        }
        initializer.block.accept(this);
    }

    public void visitInstanceof(Java.Instanceof instanceof_) {
        instanceof_.lhs.accept(this);
        this.pw.print(" instanceof ");
        instanceof_.rhs.accept(this);
    }

    public void visitLabeledStatement(Java.LabeledStatement labeledStatement) {
        this.pw.println(String.valueOf(labeledStatement.label) + ':');
        labeledStatement.body.accept(this);
    }

    public void visitLiteral(Java.Literal literal) {
        this.pw.print(literal.toString());
    }

    public void visitLocalClassDeclaration(Java.LocalClassDeclaration localClassDeclaration) {
        this.unparseNamedClassDeclaration(localClassDeclaration);
    }

    public void visitLocalClassDeclarationStatement(Java.LocalClassDeclarationStatement localClassDeclarationStatement) {
        localClassDeclarationStatement.lcd.accept(this);
    }

    public void visitLocalVariableAccess(Java.LocalVariableAccess localVariableAccess) {
        this.pw.print(localVariableAccess.toString());
    }

    public void visitLocalVariableDeclarationStatement(Java.LocalVariableDeclarationStatement localVariableDeclarationStatement) {
        this.unparseModifiers(localVariableDeclarationStatement.modifiers);
        localVariableDeclarationStatement.type.accept(this);
        this.pw.print(' ');
        this.unparseVariableDeclarator(localVariableDeclarationStatement.variableDeclarators[0]);
        int n = 1;
        while (n < localVariableDeclarationStatement.variableDeclarators.length) {
            this.pw.print(", ");
            this.unparseVariableDeclarator(localVariableDeclarationStatement.variableDeclarators[n]);
            ++n;
        }
        this.pw.print(';');
    }

    public void visitMemberClassDeclaration(Java.MemberClassDeclaration memberClassDeclaration) {
        this.unparseNamedClassDeclaration(memberClassDeclaration);
    }

    public void visitMemberInterfaceDeclaration(Java.MemberInterfaceDeclaration memberInterfaceDeclaration) {
        this.unparseInterfaceDeclaration(memberInterfaceDeclaration);
    }

    public void visitMethodDeclarator(Java.MethodDeclarator methodDeclarator) {
        this.unparseDocComment(methodDeclarator);
        this.unparseModifiers(methodDeclarator.modifiers);
        methodDeclarator.type.accept(this);
        this.pw.print(String.valueOf(' ') + methodDeclarator.name);
        this.unparseFunctionDeclaratorRest(methodDeclarator);
        if (methodDeclarator.optionalBody != null) {
            this.pw.print(' ');
            methodDeclarator.optionalBody.accept(this);
        } else {
            this.pw.print(';');
        }
    }

    public void visitMethodInvocation(Java.MethodInvocation methodInvocation) {
        if (methodInvocation.optionalTarget != null) {
            methodInvocation.optionalTarget.accept(this);
            this.pw.print('.');
        }
        this.pw.print(methodInvocation.methodName);
        this.unparseFunctionInvocationArguments(methodInvocation.arguments);
    }

    public void visitNewAnonymousClassInstance(Java.NewAnonymousClassInstance newAnonymousClassInstance) {
        if (newAnonymousClassInstance.optionalQualification != null) {
            newAnonymousClassInstance.optionalQualification.accept(this);
            this.pw.print('.');
        }
        this.pw.print("new " + newAnonymousClassInstance.anonymousClassDeclaration.baseType.toString() + '(');
        int n = 0;
        while (n < newAnonymousClassInstance.arguments.length) {
            if (n > 0) {
                this.pw.print(", ");
            }
            newAnonymousClassInstance.arguments[n].accept(this);
            ++n;
        }
        this.pw.println(") {");
        this.unparseClassDeclarationBody(newAnonymousClassInstance.anonymousClassDeclaration);
        this.pw.print('}');
    }

    public void visitNewArray(Java.NewArray newArray) {
        this.pw.print("new ");
        newArray.type.accept(this);
        int n = 0;
        while (n < newArray.dimExprs.length) {
            this.pw.print('[');
            newArray.dimExprs[n].accept(this);
            this.pw.print(']');
            ++n;
        }
        int n2 = 0;
        while (n2 < newArray.dims) {
            this.pw.print("[]");
            ++n2;
        }
    }

    public void visitNewClassInstance(Java.NewClassInstance newClassInstance) {
        if (newClassInstance.optionalQualification != null) {
            newClassInstance.optionalQualification.accept(this);
            this.pw.print('.');
        }
        this.pw.print("new " + newClassInstance.type.toString());
        this.unparseFunctionInvocationArguments(newClassInstance.arguments);
    }

    public void visitNewInitializedArray(Java.NewInitializedArray newInitializedArray) {
        this.pw.print("new ");
        newInitializedArray.arrayType.accept(this);
        this.pw.print(" ");
        this.unparseArrayInitializerOrRvalue(newInitializedArray.arrayInitializer);
    }

    public void visitPackage(Java.Package package_) {
        this.pw.print(package_.toString());
    }

    public void visitPackageMemberClassDeclaration(Java.PackageMemberClassDeclaration packageMemberClassDeclaration) {
        this.unparseNamedClassDeclaration(packageMemberClassDeclaration);
    }

    public void visitPackageMemberInterfaceDeclaration(Java.PackageMemberInterfaceDeclaration packageMemberInterfaceDeclaration) {
        this.unparseInterfaceDeclaration(packageMemberInterfaceDeclaration);
    }

    public void visitParameterAccess(Java.ParameterAccess parameterAccess) {
        this.pw.print(parameterAccess.toString());
    }

    public void visitParenthesizedExpression(Java.ParenthesizedExpression parenthesizedExpression) {
        this.pw.print('(');
        parenthesizedExpression.value.accept(this);
        this.pw.print(')');
    }

    public void visitQualifiedThisReference(Java.QualifiedThisReference qualifiedThisReference) {
        qualifiedThisReference.qualification.accept(this);
        this.pw.print(".this");
    }

    public void visitReferenceType(Java.ReferenceType referenceType) {
        this.pw.print(referenceType.toString());
    }

    public void visitReturnStatement(Java.ReturnStatement returnStatement) {
        this.pw.print("return");
        if (returnStatement.optionalReturnValue != null) {
            this.pw.print(' ');
            returnStatement.optionalReturnValue.accept(this);
        }
        this.pw.print(';');
    }

    public void visitRvalueMemberType(Java.RvalueMemberType rvalueMemberType) {
        this.pw.print(rvalueMemberType.toString());
    }

    public void visitSimpleType(Java.SimpleType simpleType) {
        this.pw.print(simpleType.toString());
    }

    public void visitSingleTypeImportDeclaration(Java.CompilationUnit.SingleTypeImportDeclaration singleTypeImportDeclaration) {
        this.pw.println("import " + Java.join(singleTypeImportDeclaration.identifiers, ".") + ';');
    }

    public void visitSuperConstructorInvocation(Java.SuperConstructorInvocation superConstructorInvocation) {
        if (superConstructorInvocation.optionalQualification != null) {
            superConstructorInvocation.optionalQualification.accept(this);
            this.pw.print('.');
        }
        this.pw.print("super");
        this.unparseFunctionInvocationArguments(superConstructorInvocation.arguments);
    }

    public void visitSuperclassMethodInvocation(Java.SuperclassMethodInvocation superclassMethodInvocation) {
        this.pw.print("super." + superclassMethodInvocation.methodName);
        this.unparseFunctionInvocationArguments(superclassMethodInvocation.arguments);
    }

    public void visitSwitchStatement(Java.SwitchStatement switchStatement) {
        this.pw.println("switch (" + switchStatement.condition + ") {");
        Iterator iterator = switchStatement.sbsgs.iterator();
        while (iterator.hasNext()) {
            Object var5_6;
            Java.SwitchStatement.SwitchBlockStatementGroup switchBlockStatementGroup;
            block5: {
                switchBlockStatementGroup = (Java.SwitchStatement.SwitchBlockStatementGroup)iterator.next();
                this.aiw.unindent();
                try {
                    Iterator iterator2 = switchBlockStatementGroup.caseLabels.iterator();
                    while (iterator2.hasNext()) {
                        Java.Rvalue rvalue = (Java.Rvalue)iterator2.next();
                        this.pw.print("case ");
                        rvalue.accept(this);
                        this.pw.println(':');
                    }
                    if (!switchBlockStatementGroup.hasDefaultLabel) break block5;
                    this.pw.println("default:");
                }
                catch (Throwable throwable) {
                    var5_6 = null;
                    this.aiw.indent();
                    throw throwable;
                }
            }
            var5_6 = null;
            this.aiw.indent();
            Iterator iterator3 = switchBlockStatementGroup.blockStatements.iterator();
            while (iterator3.hasNext()) {
                ((Java.BlockStatement)iterator3.next()).accept(this);
                this.pw.println();
            }
        }
        this.pw.print('}');
    }

    public void visitSynchronizedStatement(Java.SynchronizedStatement synchronizedStatement) {
        this.pw.print("synchronized (");
        synchronizedStatement.expression.accept(this);
        this.pw.print(") ");
        synchronizedStatement.body.accept(this);
    }

    public void visitThisReference(Java.ThisReference thisReference) {
        this.pw.print("this");
    }

    public void visitThrowStatement(Java.ThrowStatement throwStatement) {
        this.pw.print("throw ");
        throwStatement.expression.accept(this);
        this.pw.print(';');
    }

    public void visitTryStatement(Java.TryStatement tryStatement) {
        this.pw.print("try ");
        tryStatement.body.accept(this);
        Iterator iterator = tryStatement.catchClauses.iterator();
        while (iterator.hasNext()) {
            Java.CatchClause catchClause = (Java.CatchClause)iterator.next();
            this.pw.print(" catch (");
            this.unparseFormalParameter(catchClause.caughtException);
            this.pw.print(") ");
            catchClause.body.accept(this);
        }
        if (tryStatement.optionalFinally != null) {
            this.pw.print(" finally ");
            tryStatement.optionalFinally.accept(this);
        }
    }

    public void visitTypeImportOnDemandDeclaration(Java.CompilationUnit.TypeImportOnDemandDeclaration typeImportOnDemandDeclaration) {
        this.pw.println("import " + Java.join(typeImportOnDemandDeclaration.identifiers, ".") + ".*;");
    }

    public void visitUnaryOperation(Java.UnaryOperation unaryOperation) {
        this.pw.print(unaryOperation.operator);
        unaryOperation.operand.accept(this);
    }

    public void visitWhileStatement(Java.WhileStatement whileStatement) {
        this.pw.print("while (");
        whileStatement.condition.accept(this);
        this.pw.print(") ");
        whileStatement.body.accept(this);
    }
}

