/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.Map;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.MappedSuperclass;
import org.hibernate.reflection.ReflectionManager;
import org.hibernate.reflection.XClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InheritanceState {
    public XClass clazz;
    public boolean hasSons = false;
    public boolean hasParents = false;
    public InheritanceType type;
    public boolean isEmbeddableSuperclass = false;
    public String accessType = null;
    public Boolean isPropertyAnnotated;

    public InheritanceState(XClass clazz) {
        this.clazz = clazz;
        this.extractInheritanceType();
    }

    private void extractInheritanceType() {
        XClass element = this.clazz;
        Inheritance inhAnn = (Inheritance)element.getAnnotation(Inheritance.class);
        MappedSuperclass mappedSuperClass = (MappedSuperclass)element.getAnnotation(MappedSuperclass.class);
        if (mappedSuperClass != null) {
            this.isEmbeddableSuperclass = true;
            this.type = inhAnn == null ? null : inhAnn.strategy();
        } else {
            this.type = inhAnn == null ? InheritanceType.SINGLE_TABLE : inhAnn.strategy();
        }
    }

    boolean hasTable() {
        return !this.hasParents || !InheritanceType.SINGLE_TABLE.equals((Object)this.type);
    }

    boolean hasDenormalizedTable() {
        return this.hasParents && InheritanceType.TABLE_PER_CLASS.equals((Object)this.type);
    }

    public static InheritanceState getSuperEntityInheritanceState(XClass clazz, Map<XClass, InheritanceState> states, ReflectionManager reflectionManager) {
        XClass superclass = clazz;
        do {
            InheritanceState currentState;
            if ((currentState = states.get(superclass = superclass.getSuperclass())) == null || currentState.isEmbeddableSuperclass) continue;
            return currentState;
        } while (!reflectionManager.equals(superclass, Object.class));
        return null;
    }

    public static InheritanceState getSuperclassInheritanceState(XClass clazz, Map<XClass, InheritanceState> states, ReflectionManager reflectionManager) {
        XClass superclass = clazz;
        do {
            InheritanceState currentState;
            if ((currentState = states.get(superclass = superclass.getSuperclass())) == null) continue;
            return currentState;
        } while (!reflectionManager.equals(superclass, Object.class));
        return null;
    }
}

