/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.AssociationOverride;
import javax.persistence.AssociationOverrides;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.MappedSuperclass;
import org.hibernate.AssertionFailure;
import org.hibernate.cfg.ExtendedMappings;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.reflection.XAnnotatedElement;
import org.hibernate.reflection.XClass;
import org.hibernate.reflection.XProperty;
import org.hibernate.util.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPropertyHolder
implements PropertyHolder {
    protected PropertyHolder parent;
    private Map<String, Column[]> holderColumnOverride;
    private Map<String, Column[]> currentPropertyColumnOverride;
    private Map<String, JoinColumn[]> holderJoinColumnOverride;
    private Map<String, JoinColumn[]> currentPropertyJoinColumnOverride;
    private String path;
    private ExtendedMappings mappings;

    public AbstractPropertyHolder(String path, PropertyHolder parent, XClass clazzToProcess, ExtendedMappings mappings) {
        this.path = path;
        this.parent = parent;
        this.mappings = mappings;
        this.buildHierarchyColumnOverride(clazzToProcess);
    }

    @Override
    public String getPath() {
        return this.path;
    }

    protected void setCurrentProperty(XProperty property) {
        if (property == null) {
            this.currentPropertyColumnOverride = null;
            this.currentPropertyJoinColumnOverride = null;
        } else {
            this.currentPropertyColumnOverride = AbstractPropertyHolder.buildColumnOverride((XAnnotatedElement)property, this.getPath());
            if (this.currentPropertyColumnOverride.size() == 0) {
                this.currentPropertyColumnOverride = null;
            }
            this.currentPropertyJoinColumnOverride = AbstractPropertyHolder.buildJoinColumnOverride((XAnnotatedElement)property, this.getPath());
            if (this.currentPropertyJoinColumnOverride.size() == 0) {
                this.currentPropertyJoinColumnOverride = null;
            }
        }
    }

    @Override
    public Column[] getOverriddenColumn(String propertyName) {
        Column[] override = null;
        if (this.parent != null) {
            override = this.parent.getOverriddenColumn(propertyName);
        }
        if (override == null && this.currentPropertyColumnOverride != null) {
            override = this.currentPropertyColumnOverride.get(propertyName);
        }
        if (override == null && this.holderColumnOverride != null) {
            override = this.holderColumnOverride.get(propertyName);
        }
        return override;
    }

    @Override
    public JoinColumn[] getOverriddenJoinColumn(String propertyName) {
        JoinColumn[] override = null;
        if (this.parent != null) {
            override = this.parent.getOverriddenJoinColumn(propertyName);
        }
        if (override == null && this.currentPropertyJoinColumnOverride != null) {
            override = this.currentPropertyJoinColumnOverride.get(propertyName);
        }
        if (override == null && this.holderJoinColumnOverride != null) {
            override = this.holderJoinColumnOverride.get(propertyName);
        }
        return override;
    }

    private void buildHierarchyColumnOverride(XClass element) {
        Map<String, Column[]> columnOverride = new HashMap<String, Column[]>();
        Map<String, JoinColumn[]> joinColumnOverride = new HashMap<String, JoinColumn[]>();
        for (XClass current = element; current != null && !this.mappings.getReflectionManager().toXClass(Object.class).equals(current); current = current.getSuperclass()) {
            if (!current.isAnnotationPresent(Entity.class) && !current.isAnnotationPresent(MappedSuperclass.class) && !current.isAnnotationPresent(Embeddable.class)) continue;
            Map<String, Column[]> currentOverride = AbstractPropertyHolder.buildColumnOverride((XAnnotatedElement)current, this.getPath());
            Map<String, JoinColumn[]> currentJoinOverride = AbstractPropertyHolder.buildJoinColumnOverride((XAnnotatedElement)current, this.getPath());
            currentOverride.putAll(columnOverride);
            currentJoinOverride.putAll(joinColumnOverride);
            columnOverride = currentOverride;
            joinColumnOverride = currentJoinOverride;
        }
        this.holderColumnOverride = columnOverride.size() > 0 ? columnOverride : null;
        this.holderJoinColumnOverride = joinColumnOverride.size() > 0 ? joinColumnOverride : null;
    }

    private static Map<String, Column[]> buildColumnOverride(XAnnotatedElement element, String path) {
        HashMap<String, Column[]> columnOverride = new HashMap<String, Column[]>();
        if (element == null) {
            return columnOverride;
        }
        AttributeOverride singleOverride = (AttributeOverride)element.getAnnotation(AttributeOverride.class);
        AttributeOverrides multipleOverrides = (AttributeOverrides)element.getAnnotation(AttributeOverrides.class);
        AttributeOverride[] overrides = singleOverride != null ? new AttributeOverride[]{singleOverride} : (multipleOverrides != null ? multipleOverrides.value() : null);
        if (overrides != null) {
            for (AttributeOverride depAttr : overrides) {
                columnOverride.put(StringHelper.qualify((String)path, (String)depAttr.name()), new Column[]{depAttr.column()});
            }
        }
        return columnOverride;
    }

    private static Map<String, JoinColumn[]> buildJoinColumnOverride(XAnnotatedElement element, String path) {
        HashMap<String, JoinColumn[]> columnOverride = new HashMap<String, JoinColumn[]>();
        if (element == null) {
            return columnOverride;
        }
        AssociationOverride singleOverride = (AssociationOverride)element.getAnnotation(AssociationOverride.class);
        AssociationOverrides multipleOverrides = (AssociationOverrides)element.getAnnotation(AssociationOverrides.class);
        AssociationOverride[] overrides = singleOverride != null ? new AssociationOverride[]{singleOverride} : (multipleOverrides != null ? multipleOverrides.value() : null);
        if (overrides != null) {
            for (AssociationOverride depAttr : overrides) {
                columnOverride.put(StringHelper.qualify((String)path, (String)depAttr.name()), depAttr.joinColumns());
            }
        }
        return columnOverride;
    }

    @Override
    public void setParentProperty(String parentProperty) {
        throw new AssertionFailure("Setting the parent property to a non component");
    }
}

