/*
 * Decompiled with CFR 0.152.
 */
package webwork.util;

import java.util.ArrayList;
import java.util.List;

public class QuerySegment {
    public static final int STRING = 0;
    public static final int TRUE = 1;
    public static final int FALSE = 2;
    public static final int CURRENT = 3;
    public static final int PARENT = 4;
    public static final int ROOT = 5;
    public static final int ATTRIBUTE = 6;
    public static final int PARAMETER = 7;
    public static final int PROPERTY = 8;
    public static final int COLLECTION = 9;
    public static final int METHOD = 10;
    public static final int EXPAND = 11;
    public static final int NUMBER = 12;
    private String id;
    private int type;
    private List values;

    public QuerySegment(int type) {
        this.type = type;
    }

    public QuerySegment(String id, int type) {
        this.id = id;
        this.type = type;
    }

    public void addValue(Object value) {
        if (this.values == null) {
            this.values = new ArrayList();
        }
        this.values.add(value);
    }

    public String getId() {
        return this.id;
    }

    public int getType() {
        return this.type;
    }

    public List getValues() {
        return this.values;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\"");
        if (this.values != null) {
            int i = 0;
            while (i < this.values.size()) {
                sb.append(this.values.get(i));
                if (i + 1 < this.values.size()) {
                    sb.append(",");
                }
                ++i;
            }
        }
        sb.append("\"");
        return "[id=\"" + this.id + "\" type=\"" + this.type + "\" values=" + sb.toString() + "]";
    }
}

