/*
 * Decompiled with CFR 0.152.
 */
package webwork.action.factory;

import java.util.AbstractMap;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSession;

public class SessionMap
extends AbstractMap {
    HttpSession session;
    Set entries;

    public SessionMap(HttpSession s) {
        this.session = s;
    }

    public Set entrySet() {
        if (this.entries == null) {
            this.entries = new HashSet();
            Enumeration enumeration = this.session.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                final String key = enumeration.nextElement().toString();
                final Object value = this.session.getAttribute(key);
                this.entries.add(new Map.Entry(){

                    public boolean equals(Object obj) {
                        Map.Entry entry = (Map.Entry)obj;
                        return (key == null ? entry.getKey() == null : key.equals(entry.getKey())) && (value == null ? entry.getValue() == null : value.equals(entry.getValue()));
                    }

                    public int hashCode() {
                        return (key == null ? 0 : key.hashCode()) ^ (value == null ? 0 : value.hashCode());
                    }

                    public Object getKey() {
                        return key;
                    }

                    public Object getValue() {
                        return value;
                    }

                    public Object setValue(Object obj) {
                        SessionMap.this.session.setAttribute(key.toString(), obj);
                        return value;
                    }
                });
            }
        }
        return this.entries;
    }

    public Object put(Object key, Object value) {
        this.entries = null;
        this.session.setAttribute(key.toString(), value);
        return this.get(key);
    }

    public Object get(Object key) {
        return this.session.getAttribute(key.toString());
    }

    public Object remove(Object key) {
        this.entries = null;
        Object value = this.get(key);
        this.session.removeAttribute(key.toString());
        return value;
    }

    public void clear() {
        this.entries = null;
        this.session.invalidate();
    }
}

