/*
 * Decompiled with CFR 0.152.
 */
package webwork.action.factory;

import java.util.HashMap;
import java.util.Map;
import webwork.action.Action;
import webwork.action.factory.ActionFactory;

public class JavaActionFactory
extends ActionFactory {
    ClassLoader actionLoader;
    Map actionMapping = new HashMap();

    public JavaActionFactory() {
        this.actionLoader = Thread.currentThread().getContextClassLoader();
    }

    public Action getActionImpl(String name) throws Exception {
        Class<?> actionClass = (Class<?>)this.actionMapping.get(name);
        if (actionClass == null) {
            try {
                actionClass = this.actionLoader.loadClass(name);
            }
            catch (Exception e) {
                try {
                    actionClass = Class.forName(name);
                }
                catch (Exception e2) {
                    throw new IllegalArgumentException("Action '" + name + "' not found or could not be initialized: " + e2);
                }
            }
            this.actionMapping.put(name, actionClass);
        }
        try {
            return (Action)actionClass.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Action '" + name + "' could not be instantiated:" + e);
        }
    }
}

