/*
 * Decompiled with CFR 0.152.
 */
package webwork.action.client;

import java.applet.Applet;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import webwork.action.Action;
import webwork.action.client.ActionResult;

public class ClientDispatcher {
    String host;
    public static final String DISPATCHER = "/servlet/dispatch";

    public ClientDispatcher(Applet anApplet, String context) throws MalformedURLException {
        this(new URL(anApplet.getDocumentBase(), context + DISPATCHER).toExternalForm());
    }

    public ClientDispatcher(String aHost) {
        this.host = aHost;
    }

    public String getHost() {
        return this.host;
    }

    public ActionResult execute(Action anAction) throws Exception {
        URL webworkHostServlet = new URL(this.host);
        URLConnection webworkHostServletConnection = webworkHostServlet.openConnection();
        webworkHostServletConnection.setDoInput(true);
        webworkHostServletConnection.setDoOutput(true);
        webworkHostServletConnection.setUseCaches(false);
        webworkHostServletConnection.setRequestProperty("Content-Type", "application/octet-stream");
        ObjectOutputStream out = this.createObjectOutputStream(new BufferedOutputStream(webworkHostServletConnection.getOutputStream()));
        out.writeObject(anAction);
        out.flush();
        ObjectInputStream in = this.createObjectInputStream(new BufferedInputStream(webworkHostServletConnection.getInputStream()));
        ActionResult actionResult = (ActionResult)in.readObject();
        out.close();
        in.close();
        if (actionResult.getException() != null) {
            throw actionResult.getException();
        }
        return actionResult;
    }

    protected ObjectInputStream createObjectInputStream(InputStream in) throws IOException {
        return new ObjectInputStream(in);
    }

    protected ObjectOutputStream createObjectOutputStream(OutputStream out) throws IOException {
        return new ObjectOutputStream(out);
    }
}

