package org.jboss.eap.util.xp.patch.stream.manager.server.wrapper;

import java.io.Closeable;

/**
 * @author <a href="mailto:kabir.khan@jboss.com">Kabir Khan</a>
 */
public class Protocol {
    static final String START_CMD = "START";
    static final String STOP_CMD = "STOP";
    static final String EXECUTE_OPERATION_CMD = "EXECUTE_OPERATION";
    static final String APPLY_PATCH_CMD = "APPLY_PATCH";

    static final String OK_RESPONSE = "OK";
    static final String ERROR_RESPONSE = "ERROR";

    static void safeClose(Closeable closeable) {
        try {
            closeable.close();
        } catch (Exception ignore) {
        }
    }

    static String formatWithPayload(String cmdOrResponse, String payload) {
        StringBuilder sb = new StringBuilder(cmdOrResponse);
        if (payload != null) {
            sb.append(":" + payload);
        }
        return sb.toString();
    }

    static String extractPayload(String cmdWithPossiblePayload) {
        int index = cmdWithPossiblePayload.indexOf(":");
        if (index != -1 && cmdWithPossiblePayload.length() > index + 1) {
            return cmdWithPossiblePayload.substring(index + 1);
        }
        return "";
    }

    static String checkResponseAndExtractAnyPayload(String response) throws ServerException {
        if (response.startsWith(OK_RESPONSE)) {
            return extractPayload(response);
        } else if (response.startsWith(ERROR_RESPONSE)) {
            throw new ServerException();
        } else {
            throw new ServerException();
        }
    }
}
