/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.client.utils;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;

public class StreamUtils {
    public static InputStream writeTo(InputStream inputStream, OutputStream outputStream) throws IOException {
        ArrayList<Byte> data = new ArrayList<Byte>();
        int character = -1;
        while ((character = inputStream.read()) != -1) {
            data.add((byte)character);
            outputStream.write(character);
        }
        byte[] byteArray = new byte[data.size()];
        for (int i = byteArray.length - 1; i >= 0; --i) {
            byteArray[i] = (Byte)data.get(i);
        }
        return new ByteArrayInputStream(byteArray);
    }

    public static String readToString(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return null;
        }
        return StreamUtils.readToString(new InputStreamReader(inputStream));
    }

    public static String readToString(Reader reader) throws IOException {
        if (reader == null) {
            return null;
        }
        BufferedReader bufferedReader = new BufferedReader(reader);
        StringWriter writer = new StringWriter();
        String line = null;
        while ((line = bufferedReader.readLine()) != null) {
            writer.write(line);
            writer.write(10);
        }
        return writer.toString();
    }

    public static void writeTo(byte[] data, OutputStream outputStream) throws IOException {
        outputStream.write(data);
        outputStream.flush();
        outputStream.close();
    }

    public static void close(InputStream inputStream) throws IOException {
        if (inputStream != null) {
            inputStream.close();
        }
    }

    public static void quietlyClose(InputStream inputStream) {
        try {
            StreamUtils.close(inputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void close(OutputStream outputStream) throws IOException {
        if (outputStream != null) {
            outputStream.close();
        }
    }

    public static void quietlyClose(OutputStream outputStream) {
        try {
            StreamUtils.close(outputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void close(Reader reader) throws IOException {
        if (reader != null) {
            reader.close();
        }
    }

    public static void quietlyClose(Reader reader) {
        try {
            StreamUtils.close(reader);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void close(Writer writer) throws IOException {
        if (writer != null) {
            writer.close();
        }
    }

    public static void quietlyClose(Writer writer) {
        try {
            StreamUtils.close(writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

