/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.git;

import javax.inject.Inject;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.InitCommand;
import org.jboss.forge.project.dependencies.Dependency;
import org.jboss.forge.project.dependencies.DependencyBuilder;
import org.jboss.forge.project.dependencies.DependencyInstaller;
import org.jboss.forge.project.facets.BaseFacet;
import org.jboss.forge.resources.FileResource;

public class GitFacet
extends BaseFacet {
    private static final Dependency GIT_DEPENDENCY = DependencyBuilder.create().setGroupId("org.eclipse.jgit").setArtifactId("org.eclipse.jgit.pgm");
    @Inject
    public DependencyInstaller installer;

    public boolean install() {
        this.installer.install(this.project, GIT_DEPENDENCY);
        FileResource gitDir = (FileResource)this.project.getProjectRoot().getChildDirectory(".git").reify(FileResource.class);
        if (!gitDir.exists()) {
            InitCommand init = Git.init();
            init.setDirectory(this.project.getProjectRoot().getUnderlyingResourceObject());
            init.call();
        }
        return true;
    }

    public boolean isInstalled() {
        return this.installer.isInstalled(this.project, GIT_DEPENDENCY) && this.project.getProjectRoot().getChildDirectory(".git").exists();
    }
}

