/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.git;

import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.jboss.forge.git.GitFacet;
import org.jboss.forge.git.GitUtils;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.facets.events.InstallFacets;
import org.jboss.forge.resources.DirectoryResource;
import org.jboss.forge.resources.FileResource;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.ShellMessages;
import org.jboss.forge.shell.ShellPrintWriter;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.Command;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.PipeOut;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.SetupCommand;

@Alias(value="git")
public class Git
implements Plugin {
    @Inject
    private Shell shell;
    @Inject
    private Event<InstallFacets> event;
    @Inject
    private Project project;

    @SetupCommand
    public void setup(PipeOut out) {
        if (!this.project.hasFacet(GitFacet.class)) {
            this.event.fire((Object)new InstallFacets(GitFacet.class));
        } else {
            ShellMessages.info((ShellPrintWriter)out, (String)"Git repository exists already.");
        }
    }

    @Command(value="clone")
    public void gitClone(PipeOut out, @Option(description="git repo uri") String uri, @Option(description="target directory") Resource<?> folder) throws Exception {
        if (folder instanceof FileResource) {
            if (!folder.exists()) {
                ((FileResource)folder).mkdirs();
                folder = folder.reify(DirectoryResource.class);
            }
        } else {
            throw new RuntimeException();
        }
        GitUtils.clone((DirectoryResource)folder, uri);
        this.shell.setCurrentResource(folder);
    }

    @Command(value="git-checkout")
    public void gitCheckout(PipeOut out, @Option(description="branch name", defaultValue="master") String ref, @Option(name="createBranch", shortName="b") boolean createBranch, @Option(name="track", shortName="t", description="remote tracking mode", defaultValue="master") CreateBranchCommand.SetupUpstreamMode mode, @Option(name="force") boolean force) throws Exception {
        GitUtils.checkout(GitUtils.git(this.shell.getCurrentProject().getProjectRoot()), ref, createBranch, mode, force);
    }
}

