/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ant.types.attributes;

import org.apache.tools.ant.BuildException;
import org.jboss.ant.types.build.Build;

public class Version {
    private String major = "0";
    private String minor = "0";
    private String fix = "0";
    private String version = "0";

    public Version(String version) {
        this.version = version;
        this.parseVersion(version);
        this.writeVersionInfo();
    }

    protected void parseVersion(String version) {
        int majorDot = version.indexOf(".");
        if (majorDot == 0) {
            throw new BuildException("An error occurred while attempting to extract a 'major' attribute of a version from string: " + version + "\n" + "Versions which start with a '.' are not supported");
        }
        if (majorDot == -1) {
            this.major = new String(version);
            return;
        }
        this.major = new String(version.substring(0, majorDot));
        int minorDot = version.indexOf(".", majorDot + 1);
        if (minorDot == majorDot + 1) {
            throw new BuildException("An error occurred while attempting\n to extract a 'minor' attribute of a version from string: " + version + "\n" + "Versions which contain a '..' are not supported");
        }
        if (minorDot == -1) {
            this.minor = new String(version.substring(majorDot + 1));
            return;
        }
        this.minor = new String(version.substring(majorDot + 1, minorDot));
        if (version.length() > minorDot + 1) {
            this.fix = new String(version.substring(minorDot + 1));
        }
    }

    protected void writeVersionInfo() {
        Build build = Build.getBuild();
        if (build != null) {
            build.getProject().log("The version is " + this.getVersion(), 4);
            build.getProject().log("The version.major value is " + this.getMajor(), 4);
            build.getProject().log("The version.minor value is " + this.getMinor(), 4);
            build.getProject().log("The version.fix value is " + this.getFix(), 4);
        }
    }

    public String toString() {
        return this.getVersion();
    }

    public int compareTo(Version compVersion) {
        int majorCheck = 0;
        int minorCheck = 0;
        int fixCheck = 0;
        if (this.getMajor() != null) {
            majorCheck = this.getMajor().compareTo(compVersion.getMajor());
        }
        if (this.getMinor() == null && compVersion.getMinor() != null) {
            minorCheck = -1;
        }
        if (this.getMinor() != null) {
            minorCheck = this.getMinor().compareTo(compVersion.getMinor());
        }
        if (this.getFix() == null && compVersion.getFix() != null) {
            fixCheck = -1;
        }
        if (this.getFix() != null && compVersion.getFix() != null) {
            fixCheck = this.getFix().compareTo(compVersion.getFix());
        } else if (this.getFix() != null) {
            fixCheck = 1;
        }
        if (majorCheck != 0) {
            return majorCheck;
        }
        if (minorCheck != 0) {
            return minorCheck;
        }
        if (fixCheck != 0) {
            return fixCheck;
        }
        return 0;
    }

    protected String getFix() {
        return this.fix;
    }

    protected void setFix(String fix) {
        this.fix = fix;
    }

    protected String getMajor() {
        return this.major;
    }

    protected void setMajor(String major) {
        this.major = major;
    }

    protected String getMinor() {
        return this.minor;
    }

    protected void setMinor(String minor) {
        this.minor = minor;
    }

    protected String getVersion() {
        return this.version;
    }
}

