/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.diagram.editors.parts;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.Request;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.jboss.tools.hibernate.ui.diagram.editors.figures.TitleLabel;
import org.jboss.tools.hibernate.ui.diagram.editors.figures.TopLineBorder;
import org.jboss.tools.hibernate.ui.diagram.editors.model.BaseElement;
import org.jboss.tools.hibernate.ui.diagram.editors.model.ExpandableShape;
import org.jboss.tools.hibernate.ui.diagram.editors.model.Shape;
import org.jboss.tools.hibernate.ui.diagram.editors.parts.ResourceManager;
import org.jboss.tools.hibernate.ui.diagram.editors.parts.ShapeEditPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpandableShapeEditPart
extends ShapeEditPart {
    public TitleLabel getTitleLabel() {
        if (this.getFigure() instanceof TitleLabel) {
            return (TitleLabel)this.getFigure();
        }
        return null;
    }

    @Override
    protected IFigure createFigure() {
        TitleLabel label = new TitleLabel(this.getOrmDiagram().getFontHeight());
        label.setText(this.getOrmDiagram().getLabelProvider().getText(this.getElement()));
        label.setBackgroundColor(this.getColor());
        label.setIcon(this.getOrmDiagram().getLabelProvider().getImage(this.getElement()));
        label.setLabelAlignment(1);
        label.setOpaque(true);
        TopLineBorder border = new TopLineBorder(1, 2 + this.getModelShape().getIndent(), 1, 2);
        border.setColor(this.getOrmShapeEditPart().getColor());
        label.setBorder((Border)border);
        return label;
    }

    @Override
    public void activate() {
        super.activate();
        this.getModelExpandableShape().refresh();
    }

    protected ExpandableShape getModelExpandableShape() {
        return (ExpandableShape)this.getModel();
    }

    @Override
    public void performRequest(Request req) {
        if ("open".equals(req.getType())) {
            ExpandableShape es = this.getModelExpandableShape();
            if (es.isExpanded()) {
                es.collapse();
            } else {
                es.expand();
            }
        } else {
            super.performRequest(req);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if ("expanded".equals(prop)) {
            BaseElement parent;
            boolean expanded = (Boolean)evt.getNewValue();
            if (this.getTitleLabel() != null) {
                this.getTitleLabel().setExpanded(expanded);
            }
            if ((parent = this.getModelParent()).getParent() != null) {
                parent.refreshBasic();
            }
            this.getOrmDiagram().updateDirty(evt.getNewValue() != evt.getOldValue());
        } else if ("refresh".equals(prop)) {
            if (this.getTitleLabel() != null) {
                this.getTitleLabel().setExpanded(this.getModelExpandableShape().isExpanded());
            }
            super.propertyChange(evt);
            BaseElement parent = this.getModelParent();
            if (parent.getParent() != null) {
                parent.refreshBasic();
            }
        } else {
            super.propertyChange(evt);
        }
        this.refresh();
    }

    @Override
    protected void updateSelected(boolean selected) {
        if (!selected) {
            this.setSelected(0);
        }
        IFigure updateFigure = this.getFigure().getChildren().size() > 0 ? (IFigure)this.getFigure().getChildren().get(0) : this.getFigure();
        Color background = selected ? this.getSelectionColor() : this.getColor();
        Color foreground = ResourceManager.getInstance().getColor(selected ? new RGB(255, 255, 255) : new RGB(0, 0, 0));
        updateFigure.setBackgroundColor(background);
        updateFigure.setForegroundColor(foreground);
    }

    protected List<Shape> getModelChildren() {
        ArrayList<Shape> res = new ArrayList<Shape>();
        Iterator<Shape> it = this.getModelExpandableShape().getChildrenIterator();
        while (it.hasNext()) {
            res.add(it.next());
        }
        return res;
    }
}

