/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.diagram.editors.model;

import java.util.List;
import java.util.Properties;
import org.eclipse.ui.IMemento;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.jboss.tools.hibernate.ui.diagram.editors.model.Connection;
import org.jboss.tools.hibernate.ui.diagram.editors.model.Shape;

public class Utils {
    public static boolean isConnectionExist(Shape source, Shape target) {
        boolean res = false;
        if (source != null && target != null) {
            if (source.equals(target)) {
                res = true;
            } else {
                List<Connection> sourceConnections = source.getSourceConnections();
                int i = 0;
                while (!res && i < sourceConnections.size()) {
                    Connection conn = sourceConnections.get(i);
                    if (conn.getTarget().equals(target)) {
                        res = true;
                    }
                    ++i;
                }
            }
        }
        return res;
    }

    public static String getName(Object obj) {
        String res = "";
        if (obj instanceof PersistentClass) {
            PersistentClass rootClass = (PersistentClass)obj;
            res = rootClass.getEntityName() != null ? rootClass.getEntityName() : rootClass.getClassName();
        } else if (obj instanceof Table) {
            res = Utils.getTableName((Table)obj);
        } else if (obj instanceof Property) {
            Property property = (Property)obj;
            res = String.valueOf(Utils.getName(property.getPersistentClass())) + "." + property.getName();
        } else if (obj instanceof SimpleValue) {
            SimpleValue sv = (SimpleValue)obj;
            res = String.valueOf(Utils.getTableName(sv.getTable())) + "." + sv.getForeignKeyName();
        } else if (obj instanceof String) {
            res = (String)obj;
        }
        if (res.length() > 0 && res.indexOf(".") < 0) {
            return "default." + res;
        }
        if (res.length() == 0) {
            res = "null";
        }
        return res;
    }

    public static String getTableName(String catalog, String schema, String name) {
        return String.valueOf(catalog != null ? String.valueOf(catalog) + "." : "") + (schema != null ? String.valueOf(schema) + "." : "") + name;
    }

    public static String getTableName(Table table) {
        return Utils.getTableName(table.getCatalog(), table.getSchema(), table.getName());
    }

    public static void setPropertyValue(IMemento memento, String key, boolean value) {
        memento.putString(key, Boolean.valueOf(value).toString());
    }

    public static boolean getPropertyValue(IMemento memento, String key, boolean def) {
        String str = memento.getString(key);
        if (str == null) {
            str = Boolean.toString(def);
        }
        return Boolean.valueOf(str);
    }

    public static void setPropertyValue(Properties properties, String key, boolean value) {
        if (properties.containsKey(key)) {
            properties.remove(key);
        }
        properties.put(key, Boolean.valueOf(value).toString());
    }

    public static boolean getPropertyValue(Properties properties, String key, boolean def) {
        String str = properties.getProperty(key, Boolean.toString(def));
        return Boolean.valueOf(str);
    }

    public static double getPropertyValue(IMemento memento, String key, double def) {
        String str = memento.getString(key);
        if (str == null) {
            str = Double.toString(def);
        }
        return Double.valueOf(str);
    }

    public static double getPropertyValue(Properties properties, String key, double def) {
        String str = properties.getProperty(key, Double.toString(def));
        return Double.valueOf(str);
    }

    public static int getPropertyValue(IMemento memento, String key, int def) {
        String str = memento.getString(key);
        if (str == null) {
            str = Integer.toString(def);
        }
        return Integer.valueOf(str);
    }

    public static int getPropertyValue(Properties properties, String key, int def) {
        String str = properties.getProperty(key, Integer.toString(def));
        return Integer.valueOf(str);
    }

    public static String getPropertyValue(IMemento memento, String key, String def) {
        String str = memento.getString(key);
        if (str == null) {
            str = def;
        }
        return str;
    }

    public static void setPropertyValue(IMemento memento, String key, String value) {
        memento.putString(key, value);
    }

    public static String getPropertyValue(Properties properties, String key, String def) {
        return properties.getProperty(key, def);
    }

    public static void setPropertyValue(Properties properties, String key, String value) {
        if (properties.containsKey(key)) {
            properties.remove(key);
        }
        if (value != null) {
            properties.put(key, value);
        }
    }
}

