/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.diagram.editors.model;

import java.util.Properties;
import org.eclipse.ui.IMemento;
import org.jboss.tools.hibernate.ui.diagram.editors.model.Shape;

public class ExpandableShape
extends Shape {
    public static final String EXPANDED = "expanded";
    protected boolean expanded = true;

    public ExpandableShape(Object ioe, String consoleConfigName) {
        super(ioe, consoleConfigName);
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        if (expanded) {
            this.expand();
        } else {
            this.collapse();
        }
    }

    public boolean expand() {
        if (!this.isVisible()) {
            return false;
        }
        boolean expandedOld = this.expanded;
        this.expanded = true;
        this.setVisibleChildren(true);
        this.firePropertyChange(EXPANDED, expandedOld, this.expanded);
        return true;
    }

    public boolean collapse() {
        if (!this.isVisible()) {
            return false;
        }
        boolean expandedOld = this.expanded;
        this.expanded = false;
        this.setVisibleChildren(false);
        this.firePropertyChange(EXPANDED, expandedOld, this.expanded);
        return true;
    }

    public void setVisible(boolean visible) {
        boolean visibleOld = this.visible;
        this.visible = visible;
        if (this.expanded) {
            this.setVisibleChildren(visible);
        }
        this.firePropertyChange("visible", visibleOld, visible);
        this.updateVisibleValue(this.visible);
    }

    public void loadState(IMemento memento) {
        super.loadState(memento);
        boolean expanded = this.getPrValue(memento, EXPANDED, true);
        this.setExpanded(expanded);
    }

    protected void loadFromProperties(Properties properties) {
        super.loadFromProperties(properties);
        boolean expanded = this.getPrValue(properties, EXPANDED, true);
        this.setExpanded(expanded);
    }

    public void saveState(IMemento memento) {
        boolean expanded = this.isExpanded();
        this.setPrValue(memento, EXPANDED, expanded);
        super.saveState(memento);
    }

    protected void saveInProperties(Properties properties) {
        boolean expanded = this.isExpanded();
        this.setPrValue(properties, EXPANDED, expanded);
        super.saveInProperties(properties);
    }
}

