/*
 * Decompiled with CFR 0.152.
 */
package jline;

import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import jline.TerminalSupport;
import jline.console.Key;
import jline.internal.Configuration;
import jline.internal.Log;
import jline.internal.ReplayPrefixOneCharInputStream;
import org.fusesource.jansi.internal.WindowsSupport;

public class WindowsTerminal
extends TerminalSupport {
    public static final String JLINE_WINDOWS_TERMINAL_INPUT_ENCODING = "jline.WindowsTerminal.input.encoding";
    public static final String JLINE_WINDOWS_TERMINAL_OUTPUT_ENCODING = "jline.WindowsTerminal.output.encoding";
    public static final String JLINE_WINDOWS_TERMINAL_DIRECT_CONSOLE = "jline.WindowsTerminal.directConsole";
    public static final String WINDOWSBINDINGS_PROPERTIES = "windowsbindings.properties";
    public static final String ANSI = WindowsTerminal.class.getName() + ".ansi";
    private boolean directConsole;
    private int originalMode;
    private final ReplayPrefixOneCharInputStream replayStream = new ReplayPrefixOneCharInputStream(Configuration.getString("jline.WindowsTerminal.input.encoding", Configuration.getFileEncoding()));
    private final InputStreamReader replayReader = new InputStreamReader((InputStream)this.replayStream, this.replayStream.getEncoding());

    public WindowsTerminal() throws Exception {
        super(true);
    }

    public void init() throws Exception {
        super.init();
        this.setAnsiSupported(Boolean.getBoolean(ANSI));
        this.setDirectConsole(Boolean.getBoolean(JLINE_WINDOWS_TERMINAL_DIRECT_CONSOLE));
        this.originalMode = this.getConsoleMode();
        this.setConsoleMode(this.originalMode & ~ConsoleMode.ENABLE_ECHO_INPUT.code);
        this.setEchoEnabled(false);
    }

    public void restore() throws Exception {
        this.setConsoleMode(this.originalMode);
        super.restore();
    }

    public int getWidth() {
        int w = this.getWindowsTerminalWidth();
        return w < 1 ? 80 : w;
    }

    public int getHeight() {
        int h = this.getWindowsTerminalHeight();
        return h < 1 ? 24 : h;
    }

    public void setEchoEnabled(boolean enabled) {
        if (enabled) {
            this.setConsoleMode(this.getConsoleMode() | ConsoleMode.ENABLE_ECHO_INPUT.code | ConsoleMode.ENABLE_LINE_INPUT.code | ConsoleMode.ENABLE_PROCESSED_INPUT.code | ConsoleMode.ENABLE_WINDOW_INPUT.code);
        } else {
            this.setConsoleMode(this.getConsoleMode() & ~(ConsoleMode.ENABLE_LINE_INPUT.code | ConsoleMode.ENABLE_ECHO_INPUT.code | ConsoleMode.ENABLE_PROCESSED_INPUT.code | ConsoleMode.ENABLE_WINDOW_INPUT.code));
        }
        super.setEchoEnabled(enabled);
    }

    public void setDirectConsole(boolean flag) {
        this.directConsole = flag;
        Log.debug("Direct console: ", flag);
    }

    public Boolean getDirectConsole() {
        return this.directConsole;
    }

    public int readCharacter(InputStream in) throws IOException {
        if (this.directConsole || this.isSystemIn(in)) {
            return this.readByte();
        }
        return super.readCharacter(in);
    }

    private boolean isSystemIn(InputStream in) throws IOException {
        assert (in != null);
        if (in == System.in) {
            return true;
        }
        return in instanceof FileInputStream && ((FileInputStream)in).getFD() == FileDescriptor.in;
    }

    public int readVirtualKey(InputStream in) throws IOException {
        int indicator = this.readCharacter(in);
        if (indicator == WindowsKey.SPECIAL_KEY_INDICATOR.code || indicator == WindowsKey.NUMPAD_KEY_INDICATOR.code) {
            int c = this.readCharacter(in);
            WindowsKey key = WindowsKey.valueOf(c);
            switch (key) {
                case UP_ARROW_KEY: {
                    return Key.CTRL_P.code;
                }
                case LEFT_ARROW_KEY: {
                    return Key.CTRL_B.code;
                }
                case RIGHT_ARROW_KEY: {
                    return Key.CTRL_F.code;
                }
                case DOWN_ARROW_KEY: {
                    return Key.CTRL_N.code;
                }
                case DELETE_KEY: {
                    return Key.CTRL_QM.code;
                }
                case HOME_KEY: {
                    return Key.CTRL_A.code;
                }
                case END_KEY: {
                    return Key.CTRL_E.code;
                }
                case PAGE_UP_KEY: {
                    return Key.CTRL_K.code;
                }
                case PAGE_DOWN_KEY: {
                    return Key.CTRL_L.code;
                }
                case ESCAPE_KEY: {
                    return Key.CTRL_OB.code;
                }
                case INSERT_KEY: {
                    return Key.CTRL_C.code;
                }
            }
            return 0;
        }
        if (indicator > 128) {
            this.replayStream.setInput(indicator, in);
            indicator = this.replayReader.read();
        }
        return indicator;
    }

    public InputStream getDefaultBindings() {
        return WindowsTerminal.class.getResourceAsStream(WINDOWSBINDINGS_PROPERTIES);
    }

    private int getConsoleMode() {
        return WindowsSupport.getConsoleMode();
    }

    private void setConsoleMode(int mode) {
        WindowsSupport.setConsoleMode(mode);
    }

    private int readByte() {
        return WindowsSupport.readByte();
    }

    private int getWindowsTerminalWidth() {
        return WindowsSupport.getWindowsTerminalWidth();
    }

    private int getWindowsTerminalHeight() {
        return WindowsSupport.getWindowsTerminalHeight();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WindowsKey {
        SPECIAL_KEY_INDICATOR(224),
        NUMPAD_KEY_INDICATOR(0),
        LEFT_ARROW_KEY(75),
        RIGHT_ARROW_KEY(77),
        UP_ARROW_KEY(72),
        DOWN_ARROW_KEY(80),
        DELETE_KEY(83),
        HOME_KEY(71),
        END_KEY(79),
        PAGE_UP_KEY(73),
        PAGE_DOWN_KEY(81),
        INSERT_KEY(82),
        ESCAPE_KEY(0);

        public final int code;
        private static final Map<Integer, WindowsKey> codes;

        private WindowsKey(int code) {
            this.code = code;
        }

        public static WindowsKey valueOf(int code) {
            return codes.get(code);
        }

        static {
            HashMap<Integer, WindowsKey> map = new HashMap<Integer, WindowsKey>();
            for (WindowsKey key : WindowsKey.values()) {
                map.put(key.code, key);
            }
            codes = map;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConsoleMode {
        ENABLE_LINE_INPUT(2),
        ENABLE_ECHO_INPUT(4),
        ENABLE_PROCESSED_INPUT(1),
        ENABLE_WINDOW_INPUT(8),
        ENABLE_MOUSE_INPUT(16),
        ENABLE_PROCESSED_OUTPUT(1),
        ENABLE_WRAP_AT_EOL_OUTPUT(2);

        public final int code;

        private ConsoleMode(int code) {
            this.code = code;
        }
    }
}

