/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.solder.exception.control;

import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.jboss.solder.exception.control.CaughtException;
import org.jboss.solder.exception.control.HandlerMethodImpl;
import org.jboss.solder.reflection.annotated.ParameterValueRedefiner;

public class OutboundParameterValueRedefiner
implements ParameterValueRedefiner {
    private final CaughtException<?> event;
    private final BeanManager bm;
    private final Bean<?> declaringBean;
    private final HandlerMethodImpl<?> handlerMethod;

    public OutboundParameterValueRedefiner(CaughtException<?> event, BeanManager manager, HandlerMethodImpl<?> handler) {
        this.event = event;
        this.bm = manager;
        this.declaringBean = handler.getBean(manager);
        this.handlerMethod = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object redefineParameterValue(ParameterValueRedefiner.ParameterValue value) {
        CreationalContext ctx = this.bm.createCreationalContext(this.declaringBean);
        try {
            if (value.getPosition() == this.handlerMethod.getHandlerParameter().getPosition()) {
                CaughtException<?> caughtException = this.event;
                return caughtException;
            }
            Object object = value.getDefaultValue(ctx);
            return object;
        }
        finally {
            if (ctx != null) {
                ctx.release();
            }
        }
    }
}

