/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.maven.providers;

import javax.inject.Inject;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.jboss.forge.maven.MavenCoreFacet;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.services.ProjectAssociationProvider;
import org.jboss.forge.project.services.ProjectFactory;
import org.jboss.forge.resources.DirectoryResource;

public class MavenMultiModuleProvider
implements ProjectAssociationProvider {
    @Inject
    private ProjectFactory projectFactory;

    public void associate(Project project, DirectoryResource parentDir) {
        if (this.canAssociate(project, parentDir)) {
            Project parent = this.projectFactory.findProject(parentDir);
            MavenCoreFacet parentMCF = (MavenCoreFacet)parent.getFacet(MavenCoreFacet.class);
            Model parentPom = parentMCF.getPOM();
            parentPom.setPackaging("pom");
            parentPom.addModule(project.getProjectRoot().toString());
            parentMCF.setPOM(parentPom);
            MavenCoreFacet mcf = (MavenCoreFacet)project.getFacet(MavenCoreFacet.class);
            Model pom = mcf.getPOM();
            Parent parentEntry = new Parent();
            parentEntry.setGroupId(parentPom.getGroupId());
            parentEntry.setArtifactId(parentPom.getArtifactId());
            parentEntry.setVersion(parentPom.getVersion());
            pom.setParent(parentEntry);
            mcf.setPOM(pom);
        }
    }

    public boolean canAssociate(Project project, DirectoryResource parent) {
        return parent.getChild("pom.xml").exists() && project.getProjectRoot().getChild("pom.xml").exists();
    }
}

