/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.maven.dependencies;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.apache.maven.repository.internal.MavenRepositorySystemSession;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import org.jboss.forge.ForgeEnvironment;
import org.jboss.forge.maven.RepositoryUtils;
import org.jboss.forge.maven.dependencies.DependencyMetadataImpl;
import org.jboss.forge.maven.facets.MavenContainer;
import org.jboss.forge.parser.java.util.Strings;
import org.jboss.forge.project.ProjectModelException;
import org.jboss.forge.project.dependencies.DependencyBuilder;
import org.jboss.forge.project.dependencies.DependencyMetadata;
import org.jboss.forge.project.dependencies.DependencyRepository;
import org.jboss.forge.project.dependencies.DependencyRepositoryImpl;
import org.jboss.forge.project.dependencies.DependencyResolverProvider;
import org.jboss.forge.project.facets.DependencyFacet;
import org.jboss.forge.project.services.ResourceFactory;
import org.jboss.forge.resources.DependencyResource;
import org.jboss.forge.resources.DirectoryResource;
import org.jboss.forge.resources.FileResource;
import org.jboss.forge.resources.Resource;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.collection.CollectRequest;
import org.sonatype.aether.graph.Dependency;
import org.sonatype.aether.repository.ArtifactRepository;
import org.sonatype.aether.repository.LocalArtifactRequest;
import org.sonatype.aether.repository.LocalArtifactResult;
import org.sonatype.aether.repository.LocalRepository;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.repository.RepositoryPolicy;
import org.sonatype.aether.resolution.ArtifactDescriptorRequest;
import org.sonatype.aether.resolution.ArtifactDescriptorResult;
import org.sonatype.aether.resolution.ArtifactRequest;
import org.sonatype.aether.resolution.ArtifactResolutionException;
import org.sonatype.aether.resolution.ArtifactResult;
import org.sonatype.aether.resolution.DependencyRequest;
import org.sonatype.aether.resolution.DependencyResult;
import org.sonatype.aether.resolution.VersionRangeRequest;
import org.sonatype.aether.resolution.VersionRangeResult;
import org.sonatype.aether.util.artifact.DefaultArtifact;
import org.sonatype.aether.version.Version;

@Dependent
public class RepositoryLookup
implements DependencyResolverProvider {
    private MavenContainer container;
    private ResourceFactory factory;
    private ForgeEnvironment environment;

    public RepositoryLookup() {
    }

    @Inject
    public RepositoryLookup(MavenContainer container, ResourceFactory factory, ForgeEnvironment environment) {
        this.container = container;
        this.factory = factory;
        this.environment = environment;
    }

    public List<DependencyResource> resolveArtifacts(org.jboss.forge.project.dependencies.Dependency query) {
        return this.resolveArtifacts(query, new ArrayList<DependencyRepository>());
    }

    public List<DependencyResource> resolveArtifacts(org.jboss.forge.project.dependencies.Dependency query, DependencyRepository repository) {
        return this.resolveArtifacts(query, Arrays.asList(repository));
    }

    public List<DependencyResource> resolveArtifacts(org.jboss.forge.project.dependencies.Dependency dep, List<DependencyRepository> repositories) {
        DirectoryResource dir;
        ArrayList<DependencyResource> result = new ArrayList<DependencyResource>();
        RepositorySystem system = this.container.lookup(RepositorySystem.class);
        if (dep.getVersion() != null && (dir = (DirectoryResource)this.factory.getResourceFrom(new File(this.container.getSettings().getLocalRepository()))) != null && dir.exists()) {
            Resource jar;
            String seg;
            ArrayList<String> segments = new ArrayList<String>();
            segments.addAll(Arrays.asList((dep.getGroupId() + "." + dep.getArtifactId()).split("\\.")));
            segments.add(dep.getVersion());
            Iterator i$ = segments.iterator();
            while (i$.hasNext() && (dir = dir.getChildDirectory(seg = (String)i$.next())).isDirectory()) {
            }
            if (dir.isDirectory() && (jar = dir.getChild(dep.getArtifactId() + "-" + dep.getVersion() + "." + dep.getPackagingType())).exists()) {
                FileResource jarFile = (FileResource)jar.reify(FileResource.class);
                result.add(new DependencyResource(jarFile.getResourceFactory(), jarFile.getUnderlyingResourceObject(), dep));
            }
        }
        if (result.isEmpty()) {
            MavenRepositorySystemSession session = this.setupRepoSession(system);
            session.setIgnoreInvalidArtifactDescriptor(true);
            session.setIgnoreMissingArtifactDescriptor(true);
            VersionRangeResult versions = this.getVersions(dep, this.convertToMavenRepos(repositories));
            for (Version version : versions.getVersions()) {
                LocalArtifactRequest request;
                ArtifactRepository ar = versions.getRepository(version);
                DependencyBuilder currentVersion = DependencyBuilder.create((org.jboss.forge.project.dependencies.Dependency)dep).setVersion(version.toString());
                Artifact artifact = this.dependencyToMavenArtifact((org.jboss.forge.project.dependencies.Dependency)currentVersion);
                if (ar instanceof LocalRepository) {
                    request = new LocalArtifactRequest(artifact, null, null);
                    LocalArtifactResult a = session.getLocalRepositoryManager().find((RepositorySystemSession)session, request);
                    File file = a.getFile();
                    DependencyResource resource = new DependencyResource(this.factory, file, (org.jboss.forge.project.dependencies.Dependency)currentVersion);
                    if (!result.contains(resource)) {
                        result.add(resource);
                        continue;
                    }
                }
                if (!(ar instanceof RemoteRepository)) continue;
                request = new ArtifactRequest();
                RemoteRepository remoteRepo = new RemoteRepository(ar.getId(), ar.getContentType(), ((RemoteRepository)ar).getUrl());
                request.addRepository(remoteRepo);
                request.setArtifact(artifact);
                try {
                    ArtifactResult a = system.resolveArtifact((RepositorySystemSession)session, (ArtifactRequest)request);
                    File file = a.getArtifact().getFile();
                    DependencyResource resource = new DependencyResource(this.factory, file, (org.jboss.forge.project.dependencies.Dependency)currentVersion);
                    if (result.contains(resource)) continue;
                    result.add(resource);
                }
                catch (ArtifactResolutionException e) {
                    System.out.println(e.getMessage());
                }
            }
        }
        return result;
    }

    public List<DependencyResource> resolveDependencies(org.jboss.forge.project.dependencies.Dependency query) {
        return this.resolveDependencies(query, new ArrayList<DependencyRepository>());
    }

    public List<DependencyResource> resolveDependencies(org.jboss.forge.project.dependencies.Dependency query, DependencyRepository repository) {
        return this.resolveDependencies(query, Arrays.asList(repository));
    }

    public List<DependencyResource> resolveDependencies(org.jboss.forge.project.dependencies.Dependency dep, List<DependencyRepository> repositories) {
        ArrayList<DependencyResource> result = new ArrayList<DependencyResource>();
        try {
            if (Strings.isNullOrEmpty((String)dep.getVersion())) {
                dep = DependencyBuilder.create((org.jboss.forge.project.dependencies.Dependency)dep).setVersion("[,)");
            }
            RepositorySystem system = this.container.lookup(RepositorySystem.class);
            MavenRepositorySystemSession session = this.setupRepoSession(system);
            Artifact artifact = this.dependencyToMavenArtifact(dep);
            CollectRequest collectRequest = new CollectRequest(new Dependency(artifact, null), this.convertToMavenRepos(repositories));
            DependencyRequest request = new DependencyRequest(collectRequest, null);
            DependencyResult artifacts = system.resolveDependencies((RepositorySystemSession)session, request);
            for (ArtifactResult a : artifacts.getArtifactResults()) {
                File file = a.getArtifact().getFile();
                DependencyBuilder d = DependencyBuilder.create().setArtifactId(a.getArtifact().getArtifactId()).setGroupId(a.getArtifact().getGroupId()).setVersion(a.getArtifact().getVersion());
                DependencyResource resource = new DependencyResource(this.factory, file, (org.jboss.forge.project.dependencies.Dependency)d);
                result.add(resource);
            }
            return result;
        }
        catch (Exception e) {
            throw new ProjectModelException("Unable to resolve an artifact", (Throwable)e);
        }
    }

    public DependencyMetadata resolveDependencyMetadata(org.jboss.forge.project.dependencies.Dependency query) {
        return this.resolveDependencyMetadata(query, new ArrayList<DependencyRepository>());
    }

    public DependencyMetadata resolveDependencyMetadata(org.jboss.forge.project.dependencies.Dependency query, DependencyRepository repository) {
        return this.resolveDependencyMetadata(query, Arrays.asList(repository));
    }

    public DependencyMetadata resolveDependencyMetadata(org.jboss.forge.project.dependencies.Dependency query, List<DependencyRepository> repositories) {
        try {
            if (Strings.isNullOrEmpty((String)query.getVersion())) {
                query = DependencyBuilder.create((org.jboss.forge.project.dependencies.Dependency)query).setVersion("[,)");
            }
            RepositorySystem system = this.container.lookup(RepositorySystem.class);
            MavenRepositorySystemSession session = this.setupRepoSession(system);
            Artifact artifact = this.dependencyToMavenArtifact(query);
            ArtifactDescriptorRequest ar = new ArtifactDescriptorRequest(artifact, this.convertToMavenRepos(repositories), null);
            ArtifactDescriptorResult results = system.readArtifactDescriptor((RepositorySystemSession)session, ar);
            Artifact a = results.getArtifact();
            DependencyBuilder d = DependencyBuilder.create().setArtifactId(a.getArtifactId()).setGroupId(a.getGroupId()).setVersion(a.getVersion());
            return new DependencyMetadataImpl((org.jboss.forge.project.dependencies.Dependency)d, results);
        }
        catch (Exception e) {
            throw new ProjectModelException("Unable to resolve any artifacts for query [" + query + "]", (Throwable)e);
        }
    }

    public List<org.jboss.forge.project.dependencies.Dependency> resolveVersions(org.jboss.forge.project.dependencies.Dependency query) {
        return this.resolveVersions(query, new ArrayList<DependencyRepository>());
    }

    public List<org.jboss.forge.project.dependencies.Dependency> resolveVersions(org.jboss.forge.project.dependencies.Dependency query, DependencyRepository repository) {
        return this.resolveVersions(query, Arrays.asList(repository));
    }

    public List<org.jboss.forge.project.dependencies.Dependency> resolveVersions(org.jboss.forge.project.dependencies.Dependency dep, List<DependencyRepository> repositories) {
        ArrayList<org.jboss.forge.project.dependencies.Dependency> result = new ArrayList<org.jboss.forge.project.dependencies.Dependency>();
        List<RemoteRepository> remoteRepos = this.convertToMavenRepos(repositories);
        VersionRangeResult r = this.getVersions(dep, remoteRepos);
        for (Version v : r.getVersions()) {
            result.add((org.jboss.forge.project.dependencies.Dependency)DependencyBuilder.create((org.jboss.forge.project.dependencies.Dependency)dep).setVersion(v.toString()));
        }
        return result;
    }

    private MavenRepositorySystemSession setupRepoSession(RepositorySystem repoSystem) {
        MavenRepositorySystemSession session = new MavenRepositorySystemSession();
        session.setOffline(!this.environment.isOnline());
        Settings settings = this.container.getSettings();
        LocalRepository localRepo = new LocalRepository(new File(settings.getLocalRepository()), "");
        session.setLocalRepositoryManager(repoSystem.newLocalRepositoryManager(localRepo));
        session.setTransferErrorCachingEnabled(false);
        session.setNotFoundCachingEnabled(false);
        return session;
    }

    private RemoteRepository convertToMavenRepo(DependencyRepository repo) {
        RemoteRepository remoteRepository = new RemoteRepository(repo.getId(), "default", repo.getUrl());
        Settings settings = this.container.getSettings();
        Proxy activeProxy = settings.getActiveProxy();
        if (activeProxy != null) {
            remoteRepository.setProxy(RepositoryUtils.convertFromMavenProxy(activeProxy));
        }
        return remoteRepository;
    }

    private List<RemoteRepository> convertToMavenRepos(List<DependencyRepository> repositories) {
        ArrayList<DependencyRepository> temp = new ArrayList<DependencyRepository>();
        temp.addAll(repositories);
        ArrayList<RemoteRepository> remoteRepos = new ArrayList<RemoteRepository>();
        boolean hasCentral = false;
        for (DependencyRepository deprep : temp) {
            remoteRepos.add(this.convertToMavenRepo(deprep));
            if (!DependencyFacet.KnownRepository.CENTRAL.getUrl().equals(deprep.getUrl())) continue;
            hasCentral = true;
        }
        if (!hasCentral) {
            RemoteRepository central = this.convertToMavenRepo((DependencyRepository)new DependencyRepositoryImpl(DependencyFacet.KnownRepository.CENTRAL.getId(), DependencyFacet.KnownRepository.CENTRAL.getUrl()));
            central.setPolicy(true, new RepositoryPolicy().setEnabled(false));
            remoteRepos.add(central);
        }
        return remoteRepos;
    }

    private VersionRangeResult getVersions(org.jboss.forge.project.dependencies.Dependency dep, List<RemoteRepository> repositories) {
        try {
            String version = dep.getVersion();
            if (Strings.isNullOrEmpty((String)version)) {
                dep = DependencyBuilder.create((org.jboss.forge.project.dependencies.Dependency)dep).setVersion("[,)");
            } else if (!version.matches("(\\(|\\[).*?(\\)|\\])")) {
                dep = DependencyBuilder.create((org.jboss.forge.project.dependencies.Dependency)dep).setVersion("[" + version + "]");
            }
            RepositorySystem maven = this.container.lookup(RepositorySystem.class);
            MavenRepositorySystemSession session = this.setupRepoSession(maven);
            Artifact artifact = this.dependencyToMavenArtifact(dep);
            VersionRangeRequest rangeRequest = new VersionRangeRequest(artifact, repositories, null);
            VersionRangeResult rangeResult = maven.resolveVersionRange((RepositorySystemSession)session, rangeRequest);
            return rangeResult;
        }
        catch (Exception e) {
            throw new ProjectModelException("Failed to look up versions for [" + dep + "]", (Throwable)e);
        }
    }

    public Artifact dependencyToMavenArtifact(org.jboss.forge.project.dependencies.Dependency dep) {
        DefaultArtifact artifact = new DefaultArtifact(dep.getGroupId(), dep.getArtifactId(), dep.getClassifier(), dep.getPackagingType() == null ? "jar" : dep.getPackagingType(), dep.getVersion());
        return artifact;
    }
}

