/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.maven;

import javax.enterprise.inject.Typed;
import org.jboss.forge.project.BaseProject;
import org.jboss.forge.project.Facet;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.facets.FacetNotFoundException;
import org.jboss.forge.project.services.ProjectFactory;
import org.jboss.forge.resources.DirectoryResource;

@Typed
public class ProjectImpl
extends BaseProject {
    private DirectoryResource projectRoot = null;
    private final ProjectFactory factory;

    public ProjectImpl(ProjectFactory factory, DirectoryResource dir) {
        this.factory = factory;
        this.projectRoot = dir;
    }

    public <F extends Facet> F getFacet(Class<F> type) {
        try {
            return (F)super.getFacet(type);
        }
        catch (FacetNotFoundException e) {
            this.factory.registerSingleFacet((Project)this, type);
            return (F)super.getFacet(type);
        }
    }

    public DirectoryResource getProjectRoot() {
        return this.projectRoot;
    }

    public boolean exists() {
        return this.projectRoot != null && this.projectRoot.exists();
    }

    public String toString() {
        return "ProjectImpl [" + this.getProjectRoot() + "]";
    }
}

