/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.api.CherryPickResult;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.MultipleParentsNotAllowedException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.MergeMessageFormatter;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.merge.ResolveMerger;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.FileTreeIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CherryPickCommand
extends GitCommand<CherryPickResult> {
    private List<Ref> commits = new LinkedList<Ref>();

    protected CherryPickCommand(Repository repo) {
        super(repo);
    }

    @Override
    public CherryPickResult call() throws GitAPIException {
        RevCommit newHead = null;
        LinkedList<Ref> cherryPickedRefs = new LinkedList<Ref>();
        this.checkCallable();
        RevWalk revWalk = new RevWalk(this.repo);
        try {
            RevCommit headCommit;
            Ref headRef = this.repo.getRef("HEAD");
            if (headRef == null) {
                throw new NoHeadException(JGitText.get().commitOnRepoWithoutHEADCurrentlyNotSupported);
            }
            newHead = headCommit = revWalk.parseCommit(headRef.getObjectId());
            for (Ref src : this.commits) {
                Object dco;
                RevCommit srcCommit;
                ObjectId srcObjectId = src.getPeeledObjectId();
                if (srcObjectId == null) {
                    srcObjectId = src.getObjectId();
                }
                if ((srcCommit = revWalk.parseCommit(srcObjectId)).getParentCount() != 1) {
                    throw new MultipleParentsNotAllowedException(JGitText.get().canOnlyCherryPickCommitsWithOneParent);
                }
                RevCommit srcParent = srcCommit.getParent(0);
                revWalk.parseHeaders(srcParent);
                ResolveMerger merger = (ResolveMerger)MergeStrategy.RESOLVE.newMerger(this.repo);
                merger.setWorkingTreeIterator(new FileTreeIterator(this.repo));
                merger.setBase(srcParent.getTree());
                if (merger.merge(headCommit, srcCommit)) {
                    if (AnyObjectId.equals(headCommit.getTree().getId(), merger.getResultTreeId())) continue;
                } else {
                    if (merger.failed()) {
                        dco = new CherryPickResult(merger.getFailingPaths());
                        return dco;
                    }
                    String message = new MergeMessageFormatter().formatWithConflicts(srcCommit.getFullMessage(), merger.getUnmergedPaths());
                    this.repo.writeCherryPickHead(srcCommit.getId());
                    this.repo.writeMergeCommitMsg(message);
                    CherryPickResult cherryPickResult = CherryPickResult.CONFLICT;
                    return cherryPickResult;
                }
                dco = new DirCacheCheckout(this.repo, headCommit.getTree(), this.repo.lockDirCache(), merger.getResultTreeId());
                ((DirCacheCheckout)dco).setFailOnConflict(true);
                ((DirCacheCheckout)dco).checkout();
                newHead = new Git(this.getRepository()).commit().setMessage(srcCommit.getFullMessage()).setReflogComment("cherry-pick: " + srcCommit.getShortMessage()).setAuthor(srcCommit.getAuthorIdent()).call();
                cherryPickedRefs.add(src);
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionCaughtDuringExecutionOfCherryPickCommand, e), e);
        }
        finally {
            revWalk.release();
        }
        return new CherryPickResult(newHead, cherryPickedRefs);
    }

    public CherryPickCommand include(Ref commit) {
        this.checkCallable();
        this.commits.add(commit);
        return this;
    }

    public CherryPickCommand include(AnyObjectId commit) {
        return this.include(commit.getName(), commit);
    }

    public CherryPickCommand include(String name, AnyObjectId commit) {
        return this.include(new ObjectIdRef.Unpeeled(Ref.Storage.LOOSE, name, commit.copy()));
    }
}

