/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.project.resources;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.plugins.Current;

public class ResourceProducer {
    @Produces
    @Current
    public Resource getCurrentResource(InjectionPoint ip, Shell shell) {
        AnnotatedParameter annotated;
        Resource currentResource = shell.getCurrentResource();
        Type type = null;
        Member member = ip.getMember();
        if (member instanceof Field) {
            type = ((Field)member).getType();
        } else if (member instanceof Method) {
            annotated = (AnnotatedParameter)ip.getAnnotated();
            type = annotated.getBaseType();
        } else if (member instanceof Constructor) {
            annotated = (AnnotatedParameter)ip.getAnnotated();
            type = annotated.getBaseType();
        }
        try {
            ParameterizedType t;
            Type rawType;
            Class<?> resourceClass = currentResource.getClass();
            if (type instanceof Class && type.isAssignableFrom(resourceClass)) {
                return currentResource;
            }
            if (type instanceof ParameterizedType && (rawType = (t = (ParameterizedType)type).getRawType()) instanceof Class && ((Class)rawType).isAssignableFrom(resourceClass)) {
                return currentResource;
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not @Inject Resource type into InjectionPoint:" + ip, e);
        }
        return null;
    }
}

