/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.plugins.builtin;

import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Pattern;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.DefaultCommand;
import org.jboss.forge.shell.plugins.Help;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.PipeIn;
import org.jboss.forge.shell.plugins.PipeOut;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.Topic;
import org.mvel2.util.StringAppender;

@Alias(value="grep")
@Topic(value="File & Resources")
@Help(value="print lines matching a pattern")
public class GrepPlugin
implements Plugin {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DefaultCommand
    public void run(@PipeIn InputStream pipeIn, @Option(name="ignore-case", shortName="i", help="ignore case distinctions in both patterns and input", flagOnly=true) boolean ignoreCase, @Option(name="regexp", shortName="e", help="match using a regular expression") String regExp, @Option(description="PATTERN") String pattern, @Option(description="FILE ...") Resource<?>[] resources, PipeOut pipeOut) throws IOException {
        Pattern matchPattern;
        if (regExp != null) {
            if (ignoreCase) {
                regExp = regExp.toLowerCase();
            }
            matchPattern = Pattern.compile(regExp);
        } else {
            if (pattern == null) {
                throw new RuntimeException("you must specify a pattern");
            }
            if (ignoreCase) {
                pattern = pattern.toLowerCase();
            }
            matchPattern = Pattern.compile(".*" + pattern + ".*");
        }
        if (resources != null) {
            for (Resource<?> r : resources) {
                InputStream inputStream = r.getResourceInputStream();
                try {
                    this.match(inputStream, matchPattern, pipeOut, ignoreCase);
                }
                finally {
                    inputStream.close();
                }
            }
        } else if (pipeIn != null) {
            this.match(pipeIn, matchPattern, pipeOut, ignoreCase);
        } else {
            throw new RuntimeException("arguments required");
        }
    }

    private void match(InputStream instream, Pattern pattern, PipeOut out, boolean caseInsensitive) throws IOException {
        int c;
        StringAppender buf = new StringAppender();
        block3: while ((c = instream.read()) != -1) {
            switch (c) {
                case 10: 
                case 13: {
                    String s;
                    String string = s = caseInsensitive ? buf.toString().toLowerCase() : buf.toString();
                    if (pattern.matcher(s).matches()) {
                        out.println(s);
                    }
                    buf.reset();
                    continue block3;
                }
            }
            buf.append((char)c);
        }
    }
}

