/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.plugins.builtin;

import java.util.Arrays;
import java.util.Map;
import javax.inject.Inject;
import org.jboss.forge.parser.java.util.Strings;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.DefaultCommand;
import org.jboss.forge.shell.plugins.Help;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.PipeOut;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.builtin.AliasRegistry;

@Help(value="Create an alias, aliases allow a string to be substituted for a word when it is used as the first word of a simple command. Ex.: 'alias \"ls=ls -a\".See also: 'unalias'")
@Alias(value="alias")
public class AliasPlugin
implements Plugin {
    @Inject
    private AliasRegistry registry;

    @DefaultCommand
    public void set(PipeOut out, @Option(help="The alias definition: E.g: 'ls=ls -a'") String[] tokens) {
        if (tokens != null && tokens.length > 0) {
            String definition = Strings.join(Arrays.asList(tokens), (String)" ");
            if (definition.contains("=")) {
                String alias = definition.substring(0, definition.indexOf("="));
                String command = definition.substring(definition.indexOf("=") + 1);
                this.registry.createAlias(alias, command);
            }
        } else {
            for (Map.Entry<String, String> alias : this.registry.getAliases().entrySet()) {
                out.println(alias.getKey() + " = " + alias.getValue());
            }
        }
    }
}

