/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.env;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.enterprise.inject.Typed;
import org.jboss.forge.env.Configuration;
import org.jboss.forge.env.ConfigurationScope;

@Typed
public class ScopedConfigurationAdapter
implements Configuration {
    private final Map<ConfigurationScope, Configuration> delegates = new LinkedHashMap<ConfigurationScope, Configuration>();

    public ScopedConfigurationAdapter(ConfigurationScope scope, Configuration delegate) {
        this.delegates.put(scope, delegate);
    }

    public ScopedConfigurationAdapter() {
    }

    public Configuration getDelegate() {
        for (Configuration config : this.delegates.values()) {
            if (config == null) continue;
            return config;
        }
        return null;
    }

    public Configuration getScopedConfiguration(ConfigurationScope scope) {
        Configuration configuration = this.delegates.get(scope);
        if (configuration == null) {
            throw new IllegalStateException("No delegates were found in configuration - cannot retrieve scope");
        }
        return configuration;
    }

    public void setScopedConfiguration(ConfigurationScope user, Configuration config) {
        this.delegates.put(user, config);
    }

    public Configuration subset(String prefix) {
        ScopedConfigurationAdapter result = new ScopedConfigurationAdapter();
        for (Map.Entry<ConfigurationScope, Configuration> entry : this.delegates.entrySet()) {
            result.setScopedConfiguration(entry.getKey(), entry.getValue().subset(prefix));
        }
        return result;
    }

    public boolean isEmpty() {
        for (Configuration config : this.delegates.values()) {
            if (config.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean containsKey(String key) {
        for (Configuration config : this.delegates.values()) {
            if (!config.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    public void addProperty(String key, Object value) {
        this.getDelegate().addProperty(key, value);
    }

    public void setProperty(String key, Object value) {
        this.getDelegate().setProperty(key, value);
    }

    public void clearProperty(String key) {
        for (Configuration config : this.delegates.values()) {
            config.clearProperty(key);
        }
    }

    public void clear() {
        for (Configuration config : this.delegates.values()) {
            config.clear();
        }
    }

    public Object getProperty(String key) {
        for (Configuration config : this.delegates.values()) {
            Object property = config.getProperty(key);
            if (property == null) continue;
            return property;
        }
        return null;
    }

    public Iterator<?> getKeys(String prefix) {
        HashSet keys = new HashSet();
        for (Configuration config : this.delegates.values()) {
            Iterator iterator = config.getKeys(prefix);
            while (iterator.hasNext()) {
                keys.add(iterator.next());
            }
        }
        return keys.iterator();
    }

    public Iterator<?> getKeys() {
        HashSet keys = new HashSet();
        for (Configuration config : this.delegates.values()) {
            Iterator iterator = config.getKeys();
            while (iterator.hasNext()) {
                keys.add(iterator.next());
            }
        }
        return keys.iterator();
    }

    public Properties getProperties(String key) {
        Properties result = new Properties();
        for (Configuration config : this.delegates.values()) {
            result.putAll((Map<?, ?>)config.getProperties(key));
        }
        return result;
    }

    public boolean getBoolean(String key) {
        for (Configuration config : this.delegates.values()) {
            Object property = config.getProperty(key);
            if (property == null) continue;
            return config.getBoolean(key);
        }
        return this.getDelegate().getBoolean(key);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        for (Configuration config : this.delegates.values()) {
            Object property = config.getProperty(key);
            if (property == null) continue;
            return config.getBoolean(key);
        }
        return defaultValue;
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        for (Configuration config : this.delegates.values()) {
            Object property = config.getProperty(key);
            if (property == null) continue;
            return config.getBoolean(key);
        }
        return defaultValue;
    }

    public byte getByte(String key) {
        for (Configuration config : this.delegates.values()) {
            Object property = config.getProperty(key);
            if (property == null) continue;
            return config.getByte(key);
        }
        return this.getDelegate().getByte(key);
    }

    public byte getByte(String key, byte defaultValue) {
        for (Configuration config : this.delegates.values()) {
            Object property = config.getProperty(key);
            if (property == null) continue;
            return config.getByte(key);
        }
        return defaultValue;
    }

    public Byte getByte(String key, Byte defaultValue) {
        for (Configuration config : this.delegates.values()) {
            Object property = config.getProperty(key);
            if (property == null) continue;
            return config.getByte(key);
        }
        return defaultValue;
    }

    public double getDouble(String key) {
        for (Configuration config : this.delegates.values()) {
            Object property = config.getProperty(key);
            if (property == null) continue;
            return config.getDouble(key);
        }
        return this.getDelegate().getDouble(key);
    }

    public double getDouble(String key, double defaultValue) {
        for (Configuration config : this.delegates.values()) {
            Object property = config.getProperty(key);
            if (property == null) continue;
            return config.getDouble(key);
        }
        return defaultValue;
    }

    public Double getDouble(String key, Double defaultValue) {
        for (Configuration config : this.delegates.values()) {
            Object property = config.getProperty(key);
            if (property == null) continue;
            return config.getDouble(key);
        }
        return defaultValue;
    }

    public float getFloat(String key) {
        for (Configuration config : this.delegates.values()) {
            Object property = config.getProperty(key);
            if (property == null) continue;
            return config.getFloat(key);
        }
        return this.getDelegate().getFloat(key);
    }

    public float getFloat(String key, float defaultValue) {
        for (Configuration config : this.delegates.values()) {
            Object property = config.getProperty(key);
            if (property == null) continue;
            return config.getFloat(key);
        }
        return defaultValue;
    }

    public Float getFloat(String key, Float defaultValue) {
        for (Configuration config : this.delegates.values()) {
            Object property = config.getProperty(key);
            if (property == null) continue;
            return Float.valueOf(config.getFloat(key));
        }
        return defaultValue;
    }

    public int getInt(String key) {
        for (Configuration config : this.delegates.values()) {
            Object property = config.getProperty(key);
            if (property == null) continue;
            return config.getInt(key);
        }
        return this.getDelegate().getInt(key);
    }

    public int getInt(String key, int defaultValue) {
        for (Configuration config : this.delegates.values()) {
            Object property = config.getProperty(key);
            if (property == null) continue;
            return config.getInt(key);
        }
        return defaultValue;
    }

    public Integer getInteger(String key, Integer defaultValue) {
        for (Configuration config : this.delegates.values()) {
            Object property = config.getProperty(key);
            if (property == null) continue;
            return config.getInt(key);
        }
        return defaultValue;
    }

    public long getLong(String key) {
        for (Configuration config : this.delegates.values()) {
            Object property = config.getProperty(key);
            if (property == null) continue;
            return config.getLong(key);
        }
        return this.getDelegate().getLong(key);
    }

    public long getLong(String key, long defaultValue) {
        for (Configuration config : this.delegates.values()) {
            Object property = config.getProperty(key);
            if (property == null) continue;
            return config.getLong(key);
        }
        return defaultValue;
    }

    public Long getLong(String key, Long defaultValue) {
        for (Configuration config : this.delegates.values()) {
            Object property = config.getProperty(key);
            if (property == null) continue;
            return config.getLong(key);
        }
        return defaultValue;
    }

    public short getShort(String key) {
        for (Configuration config : this.delegates.values()) {
            Object property = config.getProperty(key);
            if (property == null) continue;
            return config.getShort(key);
        }
        return this.getDelegate().getShort(key);
    }

    public short getShort(String key, short defaultValue) {
        for (Configuration config : this.delegates.values()) {
            Object property = config.getProperty(key);
            if (property == null) continue;
            return config.getShort(key);
        }
        return defaultValue;
    }

    public Short getShort(String key, Short defaultValue) {
        for (Configuration config : this.delegates.values()) {
            Object property = config.getProperty(key);
            if (property == null) continue;
            return config.getShort(key);
        }
        return defaultValue;
    }

    public BigDecimal getBigDecimal(String key) {
        for (Configuration config : this.delegates.values()) {
            Object property = config.getProperty(key);
            if (property == null) continue;
            return config.getBigDecimal(key);
        }
        return this.getDelegate().getBigDecimal(key);
    }

    public BigDecimal getBigDecimal(String key, BigDecimal defaultValue) {
        for (Configuration config : this.delegates.values()) {
            Object property = config.getProperty(key);
            if (property == null) continue;
            return config.getBigDecimal(key);
        }
        return defaultValue;
    }

    public BigInteger getBigInteger(String key) {
        for (Configuration config : this.delegates.values()) {
            Object property = config.getProperty(key);
            if (property == null) continue;
            return config.getBigInteger(key);
        }
        return this.getDelegate().getBigInteger(key);
    }

    public BigInteger getBigInteger(String key, BigInteger defaultValue) {
        for (Configuration config : this.delegates.values()) {
            Object property = config.getProperty(key);
            if (property == null) continue;
            return config.getBigInteger(key);
        }
        return defaultValue;
    }

    public String getString(String key) {
        for (Configuration config : this.delegates.values()) {
            Object property = config.getProperty(key);
            if (property == null) continue;
            return config.getString(key);
        }
        return this.getDelegate().getString(key);
    }

    public String getString(String key, String defaultValue) {
        for (Configuration config : this.delegates.values()) {
            Object property = config.getProperty(key);
            if (property == null) continue;
            return config.getString(key);
        }
        return defaultValue;
    }

    public String[] getStringArray(String key) {
        for (Configuration config : this.delegates.values()) {
            Object property = config.getProperty(key);
            if (property == null) continue;
            return config.getStringArray(key);
        }
        return this.getDelegate().getStringArray(key);
    }

    public List<?> getList(String key) {
        for (Configuration config : this.delegates.values()) {
            Object property = config.getProperty(key);
            if (property == null) continue;
            return config.getList(key);
        }
        return this.getDelegate().getList(key);
    }

    public List<?> getList(String key, List<?> defaultValue) {
        for (Configuration config : this.delegates.values()) {
            Object property = config.getProperty(key);
            if (property == null) continue;
            return config.getList(key);
        }
        return defaultValue;
    }
}

