/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.command;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.command.CommandLibraryExtension;
import org.jboss.forge.shell.command.CommandMetadata;
import org.jboss.forge.shell.command.CommandMetadataImpl;
import org.jboss.forge.shell.command.OptionMetadata;
import org.jboss.forge.shell.command.PluginMetadata;
import org.jboss.forge.shell.command.PluginMetadataImpl;
import org.jboss.forge.shell.command.PluginRegistry;
import org.jboss.forge.shell.plugins.Plugin;

@Singleton
public class PluginRegistryImpl
implements PluginRegistry {
    private Map<String, List<PluginMetadata>> plugins;
    private Map<String, Map<Class<?>, PluginMetadata>> accessCache;
    private final CommandLibraryExtension library;
    private final BeanManager manager;

    @Inject
    public PluginRegistryImpl(CommandLibraryExtension library, BeanManager manager) {
        this.library = library;
        this.manager = manager;
    }

    @PostConstruct
    public void init() {
        this.plugins = this.library.getPlugins();
        this.accessCache = new HashMap();
        this.sanityCheck();
    }

    public Map<String, List<PluginMetadata>> getPlugins() {
        return this.plugins;
    }

    public void addPlugin(PluginMetadata plugin) {
        if (!this.plugins.containsKey(plugin.getName())) {
            this.plugins.put(plugin.getName(), new ArrayList());
        }
        this.plugins.get(plugin.getName()).add(plugin);
    }

    public String toString() {
        return "InstalledPluginRegistry [plugins=" + this.plugins + "]";
    }

    public Plugin instanceOf(PluginMetadata meta) {
        return (Plugin)PluginRegistryImpl.getContextualInstance(this.manager, meta.getType());
    }

    private static <T> T getContextualInstance(BeanManager manager, Class<T> type) {
        CreationalContext context;
        Object result = null;
        Bean bean = manager.resolve(manager.getBeans(type, new Annotation[0]));
        if (bean != null && (context = manager.createCreationalContext((Contextual)bean)) != null) {
            result = manager.getReference(bean, type, context);
        }
        return (T)result;
    }

    public List<PluginMetadata> getPluginMetadata(String plugin) {
        List<PluginMetadata> list = this.plugins.get(plugin);
        if (list != null && !list.isEmpty()) {
            return Collections.unmodifiableList(list);
        }
        return new ArrayList<PluginMetadata>();
    }

    public PluginMetadata getPluginMetadataForScopeAndConstraints(String name, Shell shell) {
        Class scope = shell.getCurrentResourceScope();
        if (this.accessCache.containsKey(name) && this.accessCache.get(name).containsKey(scope)) {
            return this.accessCache.get(name).get(scope);
        }
        List<PluginMetadata> pluginMetadataList = this.plugins.get(name);
        if (pluginMetadataList == null) {
            return null;
        }
        PluginMetadata pmd = null;
        for (PluginMetadata p : pluginMetadataList) {
            if (p.constrantsSatisfied(shell)) {
                pmd = p;
                break;
            }
            if (!p.isSetupAvailable(shell)) continue;
            PluginMetadataImpl temp = new PluginMetadataImpl();
            temp.setName(p.getName());
            temp.setType(p.getType());
            CommandMetadata original = p.getSetupCommand();
            CommandMetadataImpl command = new CommandMetadataImpl();
            command.setDefault(original.isDefault());
            command.setSetup(original.isSetup());
            command.setHelp(original.getHelp());
            command.setMethod(original.getMethod());
            command.setName(original.getName());
            command.setParent(temp);
            for (OptionMetadata option : original.getOptions()) {
                command.addOption(option);
            }
            temp.addCommand(command);
            pmd = temp;
            break;
        }
        return pmd;
    }

    private void sanityCheck() {
        for (Map.Entry<String, List<PluginMetadata>> entry : this.plugins.entrySet()) {
            Set scopes = null;
            for (PluginMetadata metaData : entry.getValue()) {
                if (scopes == null) {
                    scopes = metaData.getResourceScopes();
                    continue;
                }
                for (Class r : metaData.getResourceScopes()) {
                    if (!scopes.contains(r)) continue;
                    throw new RuntimeException("failed sanity check. overlapping scopes for overloaded plugin name: " + entry.getKey() + " [" + entry.getValue() + "]");
                }
            }
        }
    }
}

