/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell;

import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.forge.ForgeEnvironment;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.ShellMessages;
import org.jboss.forge.shell.ShellPrintWriter;
import org.jboss.forge.shell.events.Shutdown;
import org.jboss.forge.shell.integration.KeyListener;

public class IgnoreEofKeyListener
implements KeyListener {
    int ignoreEOFs = 0;
    int numEOFs = 0;
    private final Shell shell;
    private final Event<Shutdown> shutdown;

    @Inject
    public IgnoreEofKeyListener(Shell shell, Event<Shutdown> shutdown) {
        int propEOFs;
        ForgeEnvironment environment = shell.getEnvironment();
        String eofs = (String)environment.getProperty("IGNOREEOF");
        try {
            propEOFs = Integer.parseInt(eofs);
        }
        catch (NumberFormatException e) {
            if (shell.isVerbose()) {
                ShellMessages.info((ShellPrintWriter)shell, (String)"Unable to parse Shell property [IGNOREEOF]");
            }
            propEOFs = 1;
        }
        this.ignoreEOFs = propEOFs;
        this.shell = shell;
        this.shutdown = shutdown;
    }

    public boolean keyPress(int key) {
        if (!this.shell.isExecuting() && key == 4) {
            if (this.numEOFs < this.ignoreEOFs) {
                this.shell.println();
                this.shell.println("(Press CTRL-D again or type 'exit' to quit.)");
                ++this.numEOFs;
            } else {
                this.shell.print("exit");
                this.shutdown.fire((Object)new Shutdown(Shutdown.Status.NORMAL));
            }
            return true;
        }
        return false;
    }

    public void reset() {
        this.numEOFs = 0;
    }
}

