/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.spec.javaee.jpa.container;

import javax.inject.Inject;
import org.jboss.forge.parser.java.util.Strings;
import org.jboss.forge.shell.ShellMessages;
import org.jboss.forge.shell.ShellPrintWriter;
import org.jboss.forge.spec.javaee.jpa.api.JPADataSource;
import org.jboss.forge.spec.javaee.jpa.api.PersistenceContainer;
import org.jboss.shrinkwrap.descriptor.api.spec.jpa.persistence.PersistenceUnitDef;
import org.jboss.shrinkwrap.descriptor.api.spec.jpa.persistence.TransactionType;

public class CustomJDBCContainer
implements PersistenceContainer {
    @Inject
    private ShellPrintWriter writer;

    @Override
    public PersistenceUnitDef setupConnection(PersistenceUnitDef unit, JPADataSource dataSource) {
        unit.transactionType(TransactionType.RESOURCE_LOCAL);
        if (dataSource.getJndiDataSource() != null) {
            ShellMessages.info((ShellPrintWriter)this.writer, (String)("Ignoring JNDI data-source [" + dataSource.getJndiDataSource() + "]"));
        }
        if (!dataSource.hasNonDefaultDatabase()) {
            throw new RuntimeException("Must specify database type for JDBC connections.");
        }
        if (Strings.isNullOrEmpty((String)dataSource.getDatabaseURL())) {
            throw new RuntimeException("Must specify database URL for JDBC connections.");
        }
        if (Strings.isNullOrEmpty((String)dataSource.getUsername())) {
            throw new RuntimeException("Must specify username for JDBC connections.");
        }
        if (Strings.isNullOrEmpty((String)dataSource.getPassword())) {
            throw new RuntimeException("Must specify password for JDBC connections.");
        }
        unit.nonJtaDataSource(null);
        unit.jtaDataSource(null);
        unit.property("javax.persistence.jdbc.driver", (Object)dataSource.getJdbcDriver());
        unit.property("javax.persistence.jdbc.url", (Object)dataSource.getDatabaseURL());
        unit.property("javax.persistence.jdbc.user", (Object)dataSource.getUsername());
        unit.property("javax.persistence.jdbc.password", (Object)dataSource.getPassword());
        return unit;
    }

    @Override
    public TransactionType getTransactionType() {
        return TransactionType.RESOURCE_LOCAL;
    }
}

