/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.spec.javaee.cdi;

import java.io.FileNotFoundException;
import java.util.List;
import javax.enterprise.context.Conversation;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.forge.parser.JavaParser;
import org.jboss.forge.parser.java.Field;
import org.jboss.forge.parser.java.JavaClass;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.forge.parser.java.Method;
import org.jboss.forge.parser.java.SyntaxError;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.facets.JavaSourceFacet;
import org.jboss.forge.project.facets.events.InstallFacets;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.resources.java.JavaResource;
import org.jboss.forge.shell.PromptType;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.ShellColor;
import org.jboss.forge.shell.ShellMessages;
import org.jboss.forge.shell.ShellPrintWriter;
import org.jboss.forge.shell.ShellPrompt;
import org.jboss.forge.shell.events.PickupResource;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.Command;
import org.jboss.forge.shell.plugins.Current;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.PipeOut;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.RequiresFacet;
import org.jboss.forge.shell.plugins.RequiresResource;
import org.jboss.forge.shell.plugins.SetupCommand;
import org.jboss.forge.spec.javaee.CDIFacet;
import org.jboss.forge.spec.javaee.cdi.BeanScope;

@Alias(value="beans")
@RequiresFacet(value={CDIFacet.class})
public class BeansPlugin
implements Plugin {
    @Inject
    private Event<InstallFacets> install;
    @Inject
    private Event<PickupResource> pickup;
    @Inject
    private Project project;
    @Inject
    private ShellPrompt prompt;
    @Inject
    Shell shell;
    @Inject
    @Current
    private JavaResource resource;

    @SetupCommand
    public void setup(PipeOut out) {
        if (!this.project.hasFacet(CDIFacet.class)) {
            this.install.fire((Object)new InstallFacets(CDIFacet.class));
        }
        if (this.project.hasFacet(CDIFacet.class)) {
            ShellMessages.success((ShellPrintWriter)out, (String)"Beans (CDI) is installed.");
        }
    }

    @Command(value="list-interceptors")
    public void listInterceptors(PipeOut out) {
        CDIFacet cdi = (CDIFacet)this.project.getFacet(CDIFacet.class);
        List interceptors = cdi.getConfig().getInterceptors();
        for (String i : interceptors) {
            out.println(i);
        }
    }

    @Command(value="list-decorators")
    public void listDecorators(PipeOut out) {
        CDIFacet cdi = (CDIFacet)this.project.getFacet(CDIFacet.class);
        List decorators = cdi.getConfig().getDecorators();
        for (String d : decorators) {
            out.println(d);
        }
    }

    @Command(value="list-alternatives")
    public void listAlternatives(PipeOut out) {
        CDIFacet cdi = (CDIFacet)this.project.getFacet(CDIFacet.class);
        List classes = cdi.getConfig().getAlternativeClasses();
        List stereotypes = cdi.getConfig().getAlternativeStereotypes();
        if (!out.isPiped()) {
            out.println(ShellColor.BOLD, "Stereotypes:");
        }
        for (String s : stereotypes) {
            out.println(s);
        }
        if (!out.isPiped()) {
            out.println(ShellColor.BOLD, "Classes:");
        }
        for (String c : classes) {
            out.println(c);
        }
    }

    @Command(value="new-conversation")
    @RequiresResource(value={JavaResource.class})
    public void newConversation(@Option(name="timeout") Long timeout, @Option(name="named", defaultValue="") String name, @Option(name="beginMethodName", defaultValue="beginConversation") String beginName, @Option(name="endMethodName", defaultValue="endConversation") String endName, @Option(name="conversationFieldName", defaultValue="conversation") String fieldName, @Option(name="overwrite") boolean overwrite, PipeOut out) throws FileNotFoundException {
        if (this.resource.exists()) {
            if (this.resource.getJavaSource().isClass()) {
                JavaClass javaClass = (JavaClass)this.resource.getJavaSource();
                if (javaClass.hasField(fieldName) && !javaClass.getField(fieldName).isType(Conversation.class)) {
                    if (overwrite) {
                        javaClass.removeField(javaClass.getField(fieldName));
                    } else {
                        throw new RuntimeException("Field [" + fieldName + "] exists. Re-run with '--overwrite' to continue.");
                    }
                }
                if (javaClass.hasMethodSignature(beginName) && javaClass.getMethod(beginName).getParameters().size() == 0) {
                    if (overwrite) {
                        javaClass.removeMethod(javaClass.getMethod(beginName));
                    } else {
                        throw new RuntimeException("Method [" + beginName + "] exists. Re-run with '--overwrite' to continue.");
                    }
                }
                if (javaClass.hasMethodSignature(endName) && javaClass.getMethod(endName).getParameters().size() == 0) {
                    if (overwrite) {
                        javaClass.removeMethod(javaClass.getMethod(endName));
                    } else {
                        throw new RuntimeException("Method [" + endName + "] exists. Re-run with '--overwrite' to continue.");
                    }
                }
                ((Field)javaClass.addField().setPrivate()).setName(fieldName).setType(Conversation.class).addAnnotation(Inject.class);
                Method beginMethod = ((Method)javaClass.addMethod().setName(beginName).setReturnTypeVoid().setPublic()).setBody(fieldName + ".begin(" + name + ");");
                if (timeout != null) {
                    beginMethod.setBody(beginMethod.getBody() + "\n" + fieldName + ".setTimeout(" + timeout + ");");
                }
                ((Method)javaClass.addMethod().setName(endName).setReturnTypeVoid().setPublic()).setBody(fieldName + ".end();");
                if (javaClass.hasSyntaxErrors()) {
                    ShellMessages.info((ShellPrintWriter)out, (String)"Modified Java class contains syntax errors:");
                    for (SyntaxError error : javaClass.getSyntaxErrors()) {
                        out.print(error.getDescription());
                    }
                }
                this.resource.setContents((JavaSource)javaClass);
            } else {
                ShellMessages.error((ShellPrintWriter)out, (String)("Must operate on a Java Class file, not an [" + this.resource.getJavaSource().getSourceType() + "]"));
            }
        }
    }

    @Command(value="new-bean")
    public void newBean(@Option(required=true, name="type") JavaResource resource, @Option(required=true, name="scoped") BeanScope scope, @Option(required=false, name="overwrite") boolean overwrite) throws FileNotFoundException {
        if (!resource.exists() || overwrite) {
            JavaSourceFacet java = (JavaSourceFacet)this.project.getFacet(JavaSourceFacet.class);
            if (resource.createNewFile()) {
                JavaClass javaClass = (JavaClass)JavaParser.create(JavaClass.class);
                javaClass.setName(java.calculateName(resource));
                javaClass.setPackage(java.calculatePackage(resource));
                if (BeanScope.CUSTOM.equals((Object)scope)) {
                    String annoType = this.prompt.promptCommon("Enter the qualified custom scope type:", PromptType.JAVA_CLASS);
                    javaClass.addAnnotation(annoType);
                } else if (!BeanScope.DEPENDENT.equals((Object)scope)) {
                    javaClass.addAnnotation(scope.getAnnotation());
                }
                resource.setContents((JavaSource)javaClass);
                this.pickup.fire((Object)new PickupResource((Resource)resource));
            }
        } else {
            throw new RuntimeException("Type already exists [" + resource.getFullyQualifiedName() + "] Re-run with '--overwrite' to continue.");
        }
    }
}

