/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.descriptor.impl.spec.ee.application;

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.spec.ee.application.ApplicationDescriptor;
import org.jboss.shrinkwrap.descriptor.api.spec.ee.application.SecurityRole;
import org.jboss.shrinkwrap.descriptor.api.spec.ee.application.WebModule;
import org.jboss.shrinkwrap.descriptor.impl.spec.ee.application.SecurityRoleImpl;
import org.jboss.shrinkwrap.descriptor.impl.spec.ee.application.WebModuleImpl;
import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.spi.node.NodeDescriptorImplBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationDescriptorImpl
extends NodeDescriptorImplBase
implements ApplicationDescriptor {
    private static final String SCHEMA_LOCATION = "http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/application_%s.xsd";
    private final Node model;

    public ApplicationDescriptorImpl(String descriptorName) {
        this(descriptorName, new Node("application").attribute("xmlns", "http://java.sun.com/xml/ns/javaee").attribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance"));
        this.version("6");
    }

    public ApplicationDescriptorImpl(String descriptorName, Node model) {
        super(descriptorName);
        this.model = model;
    }

    @Override
    public ApplicationDescriptor description(String description) {
        this.model.getOrCreate("description").text(description);
        return this;
    }

    @Override
    public ApplicationDescriptor displayName(String displayName) {
        this.model.getOrCreate("display-name").text(displayName);
        return this;
    }

    @Override
    public ApplicationDescriptor libraryDirectory(String libraryDirectory) {
        this.model.getOrCreate("library-directory").text(libraryDirectory);
        return this;
    }

    @Override
    public ApplicationDescriptor ejbModule(String uri) {
        this.model.createChild("module").createChild("ejb").text(uri);
        return this;
    }

    @Override
    public ApplicationDescriptor javaModule(String uri) {
        this.model.createChild("module").createChild("java").text(uri);
        return this;
    }

    @Override
    public ApplicationDescriptor connectorModule(String uri) {
        this.model.createChild("module").createChild("connector").text(uri);
        return this;
    }

    @Override
    public ApplicationDescriptor webModule(String uri, String contextRoot) {
        Node web = this.model.createChild("module").createChild("web");
        web.createChild("web-uri").text(uri);
        web.createChild("context-root").text(contextRoot);
        return this;
    }

    @Override
    public ApplicationDescriptor version(String version) {
        if (version == null || version.length() == 0) {
            throw new IllegalArgumentException("Version must be specified");
        }
        this.model.attribute("xsi:schemaLocation", String.format(SCHEMA_LOCATION, version));
        this.model.attribute("version", version);
        return this;
    }

    @Override
    public ApplicationDescriptor securityRole(String roleName) {
        return this.securityRole(roleName, null);
    }

    @Override
    public ApplicationDescriptor securityRole(String roleName, String description) {
        Node security = this.model.createChild("security-role");
        if (roleName != null) {
            security.createChild("role-name").text(roleName);
        }
        if (description != null) {
            security.createChild("description").text(description);
        }
        return this;
    }

    public Node getRootNode() {
        return this.model;
    }

    @Override
    public String getVersion() {
        return this.model.getAttribute("version");
    }

    @Override
    public String getDisplayName() {
        return this.model.getAttribute("display-name");
    }

    @Override
    public String getDescription() {
        return this.model.getAttribute("description");
    }

    @Override
    public String getLibraryDirectory() {
        return this.model.getAttribute("library-directory");
    }

    @Override
    public List<WebModule> getWebModules() {
        ArrayList<WebModule> result = new ArrayList<WebModule>();
        List webModules = this.model.get("module/web");
        for (Node module : webModules) {
            String webUri = module.getTextValueForPatternName("web-uri");
            String contextRoot = module.getTextValueForPatternName("context-root");
            if (webUri == null && contextRoot == null) continue;
            result.add(new WebModuleImpl(webUri, contextRoot));
        }
        return result;
    }

    @Override
    public List<String> getEjbModules() {
        return this.model.getTextValuesForPatternName("module/ejb");
    }

    @Override
    public List<String> getJavaModules() {
        return this.model.getTextValuesForPatternName("module/java");
    }

    @Override
    public List<String> getConnectorModules() {
        return this.model.getTextValuesForPatternName("module/connector");
    }

    @Override
    public List<SecurityRole> getSecurityRoles() {
        ArrayList<SecurityRole> result = new ArrayList<SecurityRole>();
        List securityRoles = this.model.get("security-role");
        for (Node module : securityRoles) {
            String name = module.getTextValueForPatternName("role-name");
            String desc = module.getTextValueForPatternName("description");
            if (name == null && desc == null) continue;
            result.add(new SecurityRoleImpl(name, desc));
        }
        return result;
    }
}

