/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.toolchain;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.toolchain.DefaultToolchainManager;
import org.apache.maven.toolchain.MisconfiguredToolchainException;
import org.apache.maven.toolchain.ToolchainFactory;
import org.apache.maven.toolchain.ToolchainManagerPrivate;
import org.apache.maven.toolchain.ToolchainPrivate;
import org.apache.maven.toolchain.ToolchainsBuilder;
import org.apache.maven.toolchain.model.PersistedToolchains;
import org.apache.maven.toolchain.model.ToolchainModel;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;

@Component(role=ToolchainManagerPrivate.class)
public class DefaultToolchainManagerPrivate
extends DefaultToolchainManager
implements ToolchainManagerPrivate {
    @Requirement
    private ToolchainsBuilder toolchainsBuilder;

    public ToolchainPrivate[] getToolchainsForType(String type, MavenSession context) throws MisconfiguredToolchainException {
        List<ToolchainModel> lst;
        PersistedToolchains pers = this.toolchainsBuilder.build(context.getRequest().getUserToolchainsFile());
        ArrayList<ToolchainPrivate> toRet = new ArrayList<ToolchainPrivate>();
        if (pers != null && (lst = pers.getToolchains()) != null) {
            for (ToolchainModel toolchainModel : lst) {
                ToolchainFactory fact = (ToolchainFactory)this.factories.get(toolchainModel.getType());
                if (fact != null) {
                    toRet.add(fact.createToolchain(toolchainModel));
                    continue;
                }
                this.logger.error("Missing toolchain factory for type: " + toolchainModel.getType() + ". Possibly caused by misconfigured project.");
            }
        }
        for (ToolchainFactory toolchainFactory : this.factories.values()) {
            ToolchainPrivate tool = toolchainFactory.createDefaultToolchain();
            if (tool == null) continue;
            toRet.add(tool);
        }
        return toRet.toArray(new ToolchainPrivate[toRet.size()]);
    }

    public void storeToolchainToBuildContext(ToolchainPrivate toolchain, MavenSession session) {
        Map<String, Object> context = this.retrieveContext(session);
        context.put(DefaultToolchainManagerPrivate.getStorageKey(toolchain.getType()), toolchain.getModel());
    }
}

