/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.Context;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.XChild;
import org.jboss.tools.common.meta.XModelEntity;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;

public final class XModelObjectUtil {
    private static Map<String, String> versionedChildEntities = new HashMap<String, String>();

    public static String createNewChildName(String name, XModelObject parent) {
        if (parent.getChildByPath(name) == null) {
            return name;
        }
        int i = 0;
        while (parent.getChildByPath(String.valueOf(name) + ++i) != null) {
        }
        return String.valueOf(name) + i;
    }

    public static String[] asStringArray(String s) {
        return XModelObjectUtil.asStringArray(s, ",;");
    }

    public static String[] asStringArray(String s, String separator) {
        if (s == null || s.length() == 0) {
            return new String[0];
        }
        StringTokenizer st = new StringTokenizer(s, separator);
        String[] result = new String[st.countTokens()];
        int i = 0;
        while (i < result.length) {
            result[i] = st.nextToken().trim();
            ++i;
        }
        return result;
    }

    public static int[] asIntArray(String value) {
        String[] s = XModelObjectUtil.asStringArray(value);
        int[] result = new int[s.length];
        int i = 0;
        while (i < s.length) {
            try {
                result[i] = Integer.parseInt(s[i]);
            }
            catch (NumberFormatException numberFormatException) {
                result[i] = 0;
            }
            ++i;
        }
        return result;
    }

    public static String[][] asParameters(String s) {
        String[] sx = XModelObjectUtil.asStringArray(s);
        String[][] res = new String[sx.length][];
        int i = 0;
        while (i < sx.length) {
            String[] stringArray;
            int d = sx[i].indexOf(32);
            if (d < 0) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "";
                stringArray = stringArray2;
                stringArray2[1] = sx[i];
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = sx[i].substring(0, d);
                stringArray = stringArray3;
                stringArray3[1] = sx[i].substring(d + 1).trim();
            }
            res[i] = stringArray;
            ++i;
        }
        return res;
    }

    public static String getExpandedValue(XModelObject object, String attr, Context context) {
        return XModelObjectUtil.expand(object.getAttributeValue(attr), object.getModel(), context, new Properties());
    }

    public static String expand(String s, XModel model, Context context) {
        return XModelObjectUtil.expand(s, model, context, new Properties());
    }

    public static String expand(String s, XModel model, Context context, Properties found) {
        if (s == null || s.indexOf(37) < 0) {
            return s;
        }
        StringBuffer sb = new StringBuffer();
        XModelObjectUtil.expand(s, model, context, found, sb);
        return sb.toString();
    }

    private static void expand(String s, XModel model, Context context, Properties found, StringBuffer result) {
        if (s.length() == 0) {
            return;
        }
        int i = s.indexOf(37);
        int j = s.indexOf(37, i + 1);
        if (j <= i) {
            result.append(s);
        } else {
            result.append(s.substring(0, i));
            String q = s.substring(i + 1, j);
            s = s.substring(j + 1);
            String v = found.getProperty(q);
            if (v == null) {
                String string = v = model == null ? null : model.getProperties().getProperty(q);
                if (v == null && model != null) {
                    int d = q.lastIndexOf(46);
                    String op = d < 0 ? q : q.substring(0, d);
                    String oa = d < 0 ? "value" : q.substring(d + 1);
                    XModelObject o = model.getByPath(op);
                    v = o == null ? null : o.getAttributeValue(oa);
                }
                v = v == null ? "" : XModelObjectUtil.expand(v, model, context, found);
                found.setProperty(q, v);
            }
            result.append(v);
            XModelObjectUtil.expand(s, model, context, found, result);
        }
    }

    public static Properties toProperties(XModelObject fs) {
        return XModelObjectUtil.toProperties(fs.getAttributeValue("info"));
    }

    public static Properties toProperties(String s) {
        Properties props = new Properties();
        StringTokenizer st = new StringTokenizer(s, ",");
        while (st.hasMoreElements()) {
            String t = st.nextToken();
            int i = t.indexOf(61);
            if (i < 0) {
                props.setProperty(t, "");
                continue;
            }
            String n = t.substring(0, i).trim();
            String v = t.substring(i + 1).trim();
            props.setProperty(n, v);
        }
        return props;
    }

    public static String toString(Properties props) {
        Iterator<Map.Entry<Object, Object>> it = props.entrySet().iterator();
        String s = "";
        while (it.hasNext()) {
            Map.Entry<Object, Object> entry = it.next();
            s = String.valueOf(s) + (s.length() > 0 ? "," : "") + entry.getKey() + "=" + entry.getValue();
        }
        return s;
    }

    public static String getDocumentPublicID(XModelObject object) {
        XModelObject f = object;
        while (f != null && f.getFileType() != 1) {
            f = f.getParent();
        }
        if (f == null) {
            return null;
        }
        String r = f.getAttributeValue("publicId");
        if (r != null) {
            return r;
        }
        r = f.getAttributeValue("xsi:schemaLocation");
        return r;
    }

    public static String getXMLLocalPath(XAttribute attribute) {
        int t;
        String attr;
        if (attribute == null) {
            return null;
        }
        String tag = attribute.getModelEntity().getXMLSubPath();
        if (tag == null || tag.length() == 0) {
            tag = attribute.getModelEntity().getName();
        }
        if ((attr = attribute.getXMLName()) == null || attr.length() == 0) {
            attr = attribute.getName();
        }
        if ((t = attr.indexOf("#text")) >= 0) {
            attr = String.valueOf(attr.substring(0, t)) + "text()[1]";
        }
        String path = String.valueOf(tag.replace('.', '/')) + '/' + attr.replace('.', '/');
        while (path.lastIndexOf(47) != path.indexOf(47)) {
            path = path.substring(path.indexOf(47) + 1);
        }
        if (t < 0) {
            path = path.replace('/', '@');
        }
        return path;
    }

    public static String getVersionedChildEntity(XModelEntity parent, String entityRoot) {
        String key = String.valueOf(parent.getName()) + ":" + entityRoot;
        if (versionedChildEntities.containsKey(key)) {
            return versionedChildEntities.get(key);
        }
        XChild[] cs = parent.getChildren();
        int i = 0;
        while (i < cs.length) {
            String suff;
            String n = cs[i].getName();
            if (n.equals(entityRoot)) {
                versionedChildEntities.put(key, n);
                return n;
            }
            if (n.startsWith(entityRoot) && Character.isDigit((suff = n.substring(entityRoot.length())).charAt(0))) {
                versionedChildEntities.put(key, n);
                return n;
            }
            ++i;
        }
        String result = "Unknown_Child_" + entityRoot + "_in_" + parent.getName();
        versionedChildEntities.put(key, result);
        return result;
    }
}

