/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.util;

import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLMapper {
    Map<Node, int[]> mapping = new HashMap<Node, int[]>();
    String text;

    public XMLMapper(Document document, String text) {
        this.text = text;
        this.process(document);
    }

    int process(Node node, int index) {
        short type = node.getNodeType();
        switch (type) {
            case 3: {
                return this.processText((Text)node, index);
            }
            case 4: {
                return this.processCDATA((CharacterData)node, index);
            }
            case 1: {
                return this.processElement((Element)node, index);
            }
            case 2: {
                return this.processAttr((Attr)node, index);
            }
            case 8: {
                return this.processComment((Comment)node, index);
            }
        }
        return index;
    }

    int process(Document document) {
        int index = 0;
        NodeList n = document.getChildNodes();
        int i = 0;
        while (i < n.getLength()) {
            Node node = n.item(i);
            index = this.process(node, index);
            ++i;
        }
        return index;
    }

    int processElement(Element node, int index) {
        int headerEnd;
        NodeList n = node.getChildNodes();
        int start = this.text.indexOf("<" + node.getNodeName(), index);
        NamedNodeMap as = node.getAttributes();
        if (as != null) {
            int i = 0;
            while (i < as.getLength()) {
                Attr a = (Attr)as.item(i);
                String name = a.getNodeName();
                int ns = this.text.indexOf(name, start);
                if (ns >= 0) {
                    int q1 = this.text.indexOf(34, ns);
                    int q2 = this.text.indexOf(34, q1 + 1);
                    this.mapping.put(a, new int[]{ns, q2 + 1 - ns});
                    this.put(node, ns, q2 + 1 - ns);
                }
                ++i;
            }
        }
        if (this.text.charAt((headerEnd = this.text.indexOf(62, start)) - 1) == '/') {
            this.put(node, start, headerEnd + 1);
            return headerEnd + 1;
        }
        int ciindex = headerEnd + 1;
        int i = 0;
        while (i < n.getLength()) {
            Node cn = n.item(i);
            ciindex = this.process(cn, ciindex);
            ++i;
        }
        String token = "</" + node.getNodeName() + ">";
        int end = this.text.indexOf(token, ciindex) + token.length();
        this.put(node, start, end);
        return end;
    }

    int processText(Text node, int index) {
        int start = index;
        int end = this.text.indexOf(60, index);
        this.put(node, start, end);
        return end;
    }

    int processCDATA(CharacterData node, int index) {
        int start = this.text.indexOf("<![CDATA[", index);
        int end = this.text.indexOf("]]>", index) + 3;
        this.put(node, start, end);
        return end;
    }

    int processAttr(Attr node, int index) {
        return index;
    }

    int processComment(Comment node, int index) {
        int start = this.text.indexOf("<!--", index);
        int end = this.text.indexOf("-->", index) + 3;
        this.put(node, start, end);
        return end;
    }

    void put(Node node, int start, int end) {
        this.mapping.put(node, new int[]{start, end - start});
    }
}

