/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.project.ext.event;

import java.util.ArrayList;
import java.util.List;
import org.jboss.tools.common.model.project.ext.event.IChangeVisitor;

public class Change {
    Object target;
    String property;
    Object oldValue;
    Object newValue;
    List<Change> children;

    public Change(Object target, String property, Object oldValue, Object newValue) {
        this.target = target;
        this.property = property;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    public Object getTarget() {
        return this.target;
    }

    public String getProperty() {
        return this.property;
    }

    public Object getOldValue() {
        return this.oldValue;
    }

    public Object getNewValue() {
        return this.newValue;
    }

    public void addChildren(List<Change> children) {
        if (this.children == null) {
            this.children = children;
        } else if (children != null) {
            this.children.addAll(children);
        }
    }

    public boolean isEmpty() {
        return this.oldValue == null && this.newValue == null && !this.isChildrenAffected();
    }

    public boolean isChildrenAffected() {
        return this.children != null && !this.children.isEmpty();
    }

    public List<Change> getChildren() {
        return this.children;
    }

    public void visit(IChangeVisitor visitor) {
        if (!visitor.visit(this)) {
            return;
        }
        if (this.children != null) {
            for (Change c : this.children) {
                c.visit(visitor);
            }
        }
    }

    public static List<Change> addChange(List<Change> changes, Change change) {
        if (change == null || change.isEmpty()) {
            return changes;
        }
        if (changes == null) {
            changes = new ArrayList<Change>();
        }
        changes.add(change);
        return changes;
    }
}

