/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.options;

import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.Platform;
import org.jboss.tools.common.model.ServiceDialog;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelConstants;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelFactory;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.options.Preference;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.util.ModelFeatureFactory;

public class PreferenceModelUtilities {
    static final String ENT_OPTION_ROOT = "OptionRoot";
    private static XModel preferenceModel;

    private static ServiceDialog createServiceDialog() {
        return (ServiceDialog)ModelFeatureFactory.getInstance().createFeatureInstance("org.jboss.tools.common.model.ui.wizards.one.ServiceDialogImpl");
    }

    public static void initDefaultPreferenceModel() {
        if (preferenceModel != null) {
            return;
        }
        String f = ModelPlugin.getDefault().getStateLocation().toString();
        Properties p = new Properties();
        p.setProperty(XModelConstants.WORKSPACE, f);
        preferenceModel = PreferenceModelUtilities.createPreferenceModel(p);
        ServiceDialog d = PreferenceModelUtilities.createServiceDialog();
        if (d != null) {
            d.setModel(preferenceModel);
            preferenceModel.setService(d);
        }
    }

    public static XModel getPreferenceModel() {
        if (preferenceModel == null) {
            Platform.getBundle((String)"org.jboss.tools.common.model");
            ModelPlugin.getDefault().getPreferenceStore().getDefaultBoolean("preferenceModel");
            PreferenceModelUtilities.initDefaultPreferenceModel();
        }
        return preferenceModel;
    }

    public static XModel createPreferenceModel(Properties p) {
        p.putAll((Map<?, ?>)System.getProperties());
        p.setProperty("rootEntity", ENT_OPTION_ROOT);
        return XModelFactory.getModel(p);
    }

    public static void initPreferenceValue(XModel initialModel, Preference preference) throws XModelException {
        String newValue;
        XModelObject object;
        String value = preference.getValue();
        if (!(value != null && value.length() != 0 || (object = initialModel.getByPath(preference.getModelPath())) == null || (newValue = object.getAttributeValue(preference.getName())) == null || newValue.equals(value))) {
            preference.setValue(newValue);
        }
    }
}

