/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.impl.trees;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.constraint.XAttributeConstraintT;
import org.jboss.tools.common.model.XFilteredTree;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.project.IModelNature;
import org.jboss.tools.common.model.util.EclipseResourceUtil;

public abstract class AllResourcesTree
implements XFilteredTree {
    protected XModel preferenceModel;
    protected XModelObject root;
    protected Map<String, XFilteredTree> trees = new TreeMap<String, XFilteredTree>();
    protected XModelObject[] roots = null;

    @Override
    public void setModel(XModel model) {
        this.preferenceModel = PreferenceModelUtilities.getPreferenceModel();
        this.root = this.preferenceModel.getRoot();
        this.roots = null;
    }

    @Override
    public XModelObject getRoot() {
        return this.root;
    }

    @Override
    public boolean hasChildren(XModelObject object) {
        if (object == this.root) {
            return true;
        }
        XFilteredTree tree = this.getSubTree(object.getModel());
        if (tree != null) {
            int i = 0;
            while (i < this.roots.length) {
                if (object == this.roots[i]) {
                    object = tree.getRoot();
                }
                ++i;
            }
        }
        return tree != null && tree.hasChildren(object);
    }

    private void loadRoots() {
        if (this.roots != null) {
            return;
        }
        this.roots = new XModelObject[this.trees.size()];
        Iterator<String> it = this.trees.keySet().iterator();
        int i = 0;
        while (i < this.roots.length) {
            XFilteredTree tree = this.trees.get(it.next());
            this.roots[i] = tree.getRoot().getParent();
            ++i;
        }
    }

    @Override
    public XModelObject[] getChildren(XModelObject object) {
        this.loadRoots();
        if (object == this.root) {
            return this.roots;
        }
        XFilteredTree tree = this.getSubTree(object.getModel());
        if (tree != null) {
            int i = 0;
            while (i < this.roots.length) {
                if (object == this.roots[i]) {
                    object = tree.getRoot();
                }
                ++i;
            }
        }
        return tree == null ? new XModelObject[]{} : tree.getChildren(object);
    }

    @Override
    public XModelObject getChildAt(XModelObject object, int i) {
        this.loadRoots();
        if (object == this.root) {
            return this.roots[i];
        }
        XFilteredTree tree = this.getSubTree(object.getModel());
        if (tree != null) {
            int k = 0;
            while (k < this.roots.length) {
                if (object == this.roots[k]) {
                    object = tree.getRoot();
                }
                ++k;
            }
        }
        return tree == null ? null : tree.getChildAt(object, i);
    }

    @Override
    public boolean isSelectable(XModelObject object) {
        if (object == this.root) {
            return false;
        }
        XFilteredTree tree = this.getSubTree(object.getModel());
        return tree != null && tree.isSelectable(object);
    }

    @Override
    public String getValue(XModelObject object) {
        if (object == this.root) {
            return "";
        }
        IResource resource = (IResource)object.getAdapter(IResource.class);
        if (resource == null) {
            XFilteredTree tree = this.getSubTree(object.getModel());
            return "/" + EclipseResourceUtil.getProject(object).getName() + "/" + tree.getValue(object);
        }
        return resource == null ? "" : resource.getFullPath().toString();
    }

    @Override
    public void setConstraint(Object object) {
        Object[] os = (Object[])object;
        XAttribute a = (XAttribute)os[0];
        XAttributeConstraintT tc = (XAttributeConstraintT)a.getConstraint();
        String nature = tc.getProperties().getProperty("nature");
        IProject[] ps = ModelPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < ps.length) {
            block8: {
                if (ps[i].isOpen()) {
                    try {
                        if (nature != null && !ps[i].hasNature(nature)) {
                        }
                    }
                    catch (CoreException e) {
                        if (ModelPlugin.isDebugEnabled()) {
                            ModelPlugin.getPluginLog().logInfo("AllResourcesTree:" + e.getMessage());
                        }
                        break block8;
                    }
                    IModelNature sp = EclipseResourceUtil.getModelNature(ps[i]);
                    if (sp != null) {
                        XModel model_i = sp.getModel();
                        XFilteredTree tree = this.createProjectTree();
                        tree.setModel(model_i);
                        tree.setConstraint(object);
                        if (tree.getRoot() != null) {
                            this.trees.put(ps[i].getName(), tree);
                        }
                    }
                }
            }
            ++i;
        }
    }

    protected abstract XFilteredTree createProjectTree();

    private XFilteredTree getSubTree(XModel model) {
        return this.trees.get(((IProject)model.getProperties().get("project")).getName());
    }

    @Override
    public XModelObject find(String value) {
        if (value == null || value.length() == 0) {
            return this.root;
        }
        if (value.indexOf("//") >= 0) {
            String pn = value.substring(1, value.indexOf("//"));
            XFilteredTree tree = this.trees.get(pn);
            return tree == null ? null : tree.getRoot().getModel().getByPath(value.substring(value.indexOf("//") + 1));
        }
        if (value.indexOf("/", 1) < 0) {
            return null;
        }
        IFolder r = ModelPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(value));
        if (r == null || !r.exists()) {
            r = ModelPlugin.getWorkspace().getRoot().getFile((IPath)new Path(value));
        }
        if (r == null || !r.exists()) {
            return null;
        }
        return EclipseResourceUtil.getObjectByResource((IResource)r);
    }

    @Override
    public XModelObject getParent(XModelObject object) {
        if (object == this.root) {
            return null;
        }
        XFilteredTree tree = this.getSubTree(object.getModel());
        if (tree == null) {
            return null;
        }
        if (tree.getRoot() == object) {
            return this.root;
        }
        XModelObject p = tree.getParent(object);
        if (p == tree.getRoot()) {
            return p.getParent();
        }
        return p;
    }

    @Override
    public String getPath(XModelObject object) {
        if (object == this.root) {
            return "";
        }
        IResource resource = (IResource)object.getAdapter(IResource.class);
        return resource == null ? "" : resource.getFullPath().toString();
    }

    @Override
    public void dispose() {
    }
}

