/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.filesystems.impl;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.jboss.tools.common.model.XModelConstants;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.model.filesystems.impl.FileSystemImpl;
import org.jboss.tools.common.model.filesystems.impl.FileSystemsImpl;
import org.jboss.tools.common.model.filesystems.impl.FileSystemsLoaderUtil;
import org.jboss.tools.common.model.filesystems.impl.JarSystemImpl;
import org.jboss.tools.common.model.filesystems.impl.Libs;
import org.jboss.tools.common.model.loaders.XObjectLoader;
import org.jboss.tools.common.model.loaders.impl.URLRootLoader;
import org.jboss.tools.common.model.project.IAutoLoad;
import org.jboss.tools.common.model.project.WatcherLoader;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;

public class FileSystemsLoader
extends URLRootLoader {
    public static String IS_ADDED_TO_CLASSPATH = "isAddedToClassPath";
    FileSystemsLoaderUtil fsutil = new FileSystemsLoaderUtil();
    List<String> paths = null;

    @Override
    protected XModelObjectLoaderUtil util() {
        return this.fsutil;
    }

    @Override
    public boolean save(XModelObject object) {
        boolean b;
        if (!this.fsutil.isModified(object)) {
            return true;
        }
        if (object.getModel().getProperties().get(XModelConstants.AUTOLOAD) != null) {
            return true;
        }
        String s = this.getEclipseFileName(object, false);
        boolean bl = b = s == null ? super.save(object.copy(1)) : this.saveEclipse(object.copy(1));
        if (((FileSystemsImpl)object).requestSave()) {
            return true;
        }
        XModelObject[] cs = object.getChildren();
        int i = 0;
        while (i < cs.length) {
            XObjectLoader loader = XModelObjectLoaderUtil.getObjectLoader(cs[i]);
            if (loader != null) {
                b &= loader.save(cs[i]);
            }
            ++i;
        }
        return b;
    }

    @Override
    public boolean update(XModelObject object) throws XModelException {
        boolean b = true;
        IAutoLoad auto = (IAutoLoad)object.getModel().getProperties().get(XModelConstants.AUTOLOAD);
        if (auto != null) {
            auto.update(object.getModel());
        }
        XModelObject[] cs = object.getChildren();
        int i = 0;
        while (i < cs.length) {
            XObjectLoader loader = XModelObjectLoaderUtil.getObjectLoader(cs[i]);
            if (loader != null) {
                b &= loader.update(cs[i]);
            }
            ++i;
        }
        this.updateClassPath(object);
        ((FileSystemsImpl)object).updateOverlapped();
        return b;
    }

    public void updateClassPath(XModelObject object) {
        this.updateLibs(object);
        this.removeMissingJarSystems(object);
        this.updateSrcs(object);
    }

    @Override
    public void load(XModelObject object) {
        if (EclipseResourceUtil.isProjectFragment(object.getModel())) {
            return;
        }
        IAutoLoad auto = (IAutoLoad)object.getModel().getProperties().get(XModelConstants.AUTOLOAD);
        if (auto != null) {
            auto.load(object.getModel());
            this.updateLibs(object);
            FileSystemsLoader._updateSrcs(object);
            ((FileSystemsImpl)object).updateOverlapped();
            return;
        }
        String f = this.getEclipseFileName(object, true);
        if (f == null) {
            super.load(object);
        } else {
            this.util().load(new File(f), object);
        }
        XModelObject[] os = object.getChildren();
        int i = 0;
        while (i < os.length) {
            String s = os[i].getAttributeValue("location");
            if (s != null && s.startsWith(XModelConstants.WORKSPACE_OLD_REF)) {
                s = String.valueOf(XModelConstants.WORKSPACE_REF) + s.substring(XModelConstants.WORKSPACE_OLD_REF.length());
                os[i].setAttributeValue("location", s);
            }
            ++i;
        }
        this.removeMissingJarSystems(object);
    }

    void removeMissingJarSystems(XModelObject object) {
        XModelObject[] os = object.getChildren("FileSystemJar");
        int i = 0;
        while (i < os.length) {
            JarSystemImpl jar = (JarSystemImpl)os[i];
            String location = jar.getLocation();
            if (location != null && !new File(location).isFile()) {
                jar.removeFromParent();
                object.setModified(true);
            }
            ++i;
        }
    }

    @Override
    public String fileroot(XModelObject object) {
        return String.valueOf(XModelConstants.getWorkspace(object.getModel())) + "/";
    }

    @Override
    protected String fileName(XModelObject object) {
        return "workspace.pex";
    }

    private boolean saveEclipse(XModelObject object) {
        IFile file;
        boolean b;
        String f = this.getEclipseFileName(object, false);
        boolean bl = b = f != null && this.util().save(new File(f), object);
        if (b && (file = EclipseResourceUtil.getFile(f)) != null) {
            try {
                file.refreshLocal(0, null);
            }
            catch (CoreException coreException) {}
        }
        return b;
    }

    private String getEclipseFileName(XModelObject object, boolean load) {
        String project = object.getModel().getProperties().getProperty("eclipse.project");
        if (project == null) {
            return null;
        }
        String fn = String.valueOf(project) + "/" + ".settings/org.jboss.tools.jst.web.xml";
        if (!load || new File(fn).exists()) {
            return fn;
        }
        return null;
    }

    private void updateLibs(XModelObject object) {
        if (WatcherLoader.isLocked(object.getModel())) {
            return;
        }
        IProject project = EclipseResourceUtil.getProject(object);
        if (project == null) {
            return;
        }
        this.validateLib(object);
        Libs libs = FileSystemsHelper.getLibs(object);
        if (libs != null) {
            libs.update();
        }
    }

    private XModelObject validateLib(XModelObject object) {
        XModelObject lib = object.getChildByPath("lib");
        if (lib == null) {
            XModelObject wi = object.getChildByPath("WEB-INF");
            if (wi == null) {
                return null;
            }
            XModelObject lb = wi.getChildByPath("lib");
            if (lb == null) {
                return null;
            }
            lib = wi.getModel().createModelObject("FileSystemFolder", null);
            lib.setAttributeValue("name", "lib");
            lib.setAttributeValue("location", String.valueOf(wi.getAttributeValue("location")) + "/lib");
            object.addChild(lib);
            object.setModified(true);
        }
        return lib;
    }

    public void updateSrcs(XModelObject object) {
        IAutoLoad auto = (IAutoLoad)object.getModel().getProperties().get(XModelConstants.AUTOLOAD);
        if (auto == null && WatcherLoader.isLocked(object.getModel())) {
            return;
        }
        FileSystemsLoader._updateSrcs(object);
    }

    private static void _updateSrcs(XModelObject object) {
        IProject p = EclipseResourceUtil.getProject(object);
        if (p == null || !p.isAccessible()) {
            return;
        }
        String[] srcs = EclipseResourceUtil.getJavaProjectSrcLocations(p);
        HashSet<String> paths = new HashSet<String>();
        int i = 0;
        while (i < srcs.length) {
            String path = EclipseResourceUtil.getRelativeLocation(object.getModel(), srcs[i]);
            if (path != null) {
                paths.add(path);
            }
            ++i;
        }
        XModelObject[] cs = object.getChildren("FileSystemFolder");
        int i2 = 0;
        while (i2 < cs.length) {
            if (cs[i2].getAttributeValue("name").startsWith("src")) {
                String loc = cs[i2].getAttributeValue("location");
                if (!paths.contains(loc)) {
                    object.removeChild(cs[i2]);
                } else {
                    paths.remove(loc);
                }
            }
            ++i2;
        }
        for (String path : paths) {
            String n = FileSystemsLoader.getNextSrcName(object);
            Properties properties = new Properties();
            properties.setProperty("location", path);
            properties.setProperty("name", n);
            FileSystemImpl s = (FileSystemImpl)object.getModel().createModelObject("FileSystemFolder", properties);
            object.addChild(s);
        }
    }

    private static String getNextSrcName(XModelObject object) {
        if (object.getChildByPath("src") == null) {
            return "src";
        }
        int i = 1;
        String s;
        while (object.getChildByPath(s = "src-" + i) != null) {
            ++i;
        }
        return s;
    }
}

