/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.meta.action.impl;

import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.eclipse.swt.widgets.Display;
import org.jboss.tools.common.meta.XMapping;
import org.jboss.tools.common.meta.action.XAction;
import org.jboss.tools.common.meta.action.XAttributeData;
import org.jboss.tools.common.meta.action.XEntityData;
import org.jboss.tools.common.meta.action.impl.DefaultWizardDataValidator;
import org.jboss.tools.common.meta.action.impl.SpecialWizardControlListener;
import org.jboss.tools.common.meta.action.impl.WizardDataValidator;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultCreateHandler;
import org.jboss.tools.common.meta.action.impl.handlers.HUtil;
import org.jboss.tools.common.meta.help.HelpUtil;
import org.jboss.tools.common.meta.key.WizardKeys;
import org.jboss.tools.common.model.Messages;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;

public abstract class SpecialWizardSupport {
    public static final String OK = Messages.SpecialWizardSupport_OK;
    public static final String CANCEL = Messages.SpecialWizardSupport_Cancel;
    public static final String BACK = Messages.SpecialWizardSupport_BackArrow;
    public static final String NEXT = Messages.SpecialWizardSupport_NextArrow;
    public static final String FINISH = Messages.SpecialWizardSupport_Finish;
    public static final String HELP = Messages.SpecialWizardSupport_Help;
    public static final String CLOSE = Messages.SpecialWizardSupport_Close;
    static final Set<String> standardButtons = new HashSet<String>();
    private int stepId = 0;
    private boolean finished = false;
    private XEntityData[] data = null;
    protected XAction action = null;
    protected XModelObject target;
    protected Properties p;
    private SpecialWizardControlListener listener = null;
    private Thread thread = null;
    protected DefaultWizardDataValidator defaultValidator = new DefaultWizardDataValidator();
    static String DEFAULT_IMLEMENTING_CLASS;

    static {
        standardButtons.add(OK);
        standardButtons.add(CANCEL);
        standardButtons.add(BACK);
        standardButtons.add(NEXT);
        standardButtons.add(FINISH);
        standardButtons.add(HELP);
        standardButtons.add(CLOSE);
        DEFAULT_IMLEMENTING_CLASS = "org.jboss.tools.common.model.ui.wizards.special.SpecialWizardStep";
    }

    public void dispose() {
    }

    public final void setAction(XAction action) {
        this.action = action;
    }

    public final void setActionData(XAction action, XEntityData[] data, XModelObject target, Properties p) {
        this.action = action;
        this.data = data;
        this.target = target;
        this.p = p != null ? p : new Properties();
        this.stepId = 0;
        this.finished = false;
        this.reset();
    }

    public void help() throws XModelException {
        HelpUtil.helpEclipse(this.getTarget().getModel(), this.getHelpKey());
    }

    protected void reset() {
    }

    public final XEntityData[] getEntityData() {
        return this.data;
    }

    public String getTitle() {
        String n;
        String title = WizardKeys.getHeader(this.getHelpKey());
        if (title != null) {
            return title;
        }
        if (this.getEntityData().length > 0) {
            title = WizardKeys.getHeader(this.action, this.getEntityData()[0].getModelEntity());
        }
        if (title != null) {
            return title;
        }
        String string = n = this.action == null ? "" : this.action.getDisplayName();
        if (n.endsWith("...")) {
            n = n.substring(0, n.length() - 3);
        }
        return n;
    }

    public String getSubtitle() {
        String key = this.getHelpKey();
        String t = WizardKeys.getTitle(key);
        if (t == null && key != null && key.endsWith("_0")) {
            String key1 = key.substring(0, key.length() - 2);
            t = WizardKeys.getTitle(key1);
        }
        if (t == null && this.getEntityData().length > 0) {
            t = WizardKeys.getTitle(this.action, this.getEntityData()[0].getModelEntity());
        }
        return t;
    }

    public boolean isEnabled(XModelObject target) {
        return target != null && target.isObjectEditable();
    }

    public String getMessage(int stepId) {
        return WizardKeys.getMessage(this.getHelpKey());
    }

    public String[][] getInfo(int stepId) {
        return new String[0][0];
    }

    public String getAttributeMessage(int stepId, String attrname) {
        return null;
    }

    public void setControlListener(SpecialWizardControlListener listener) {
        this.listener = listener;
    }

    public void fireCommand(final String command) {
        if (this.listener != null) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    SpecialWizardSupport.this.listener.action(command);
                }
            });
        }
    }

    public int getStepId() {
        return this.stepId;
    }

    public final void setStepId(int stepId) {
        this.stepId = stepId;
    }

    public final boolean isFinished() {
        return this.finished;
    }

    public final void setFinished(boolean b) {
        this.finished = b;
    }

    public abstract void action(String var1) throws XModelException;

    public String[] getActionNames(int stepId) {
        return new String[]{OK, CANCEL, HELP};
    }

    public boolean canBeProcessedByStandardWizard() {
        if (this.data == null || this.data.length > 1) {
            return false;
        }
        if (!DEFAULT_IMLEMENTING_CLASS.equals(this.getStepImplementingClass(0))) {
            return false;
        }
        String[] buttons = this.getActionNames(0);
        int i = 0;
        while (i < buttons.length) {
            if (!standardButtons.contains(buttons[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String getDefaultActionName(int stepId) {
        String[] actions = this.getActionNames(stepId);
        if (actions == null || actions.length == 0) {
            return null;
        }
        HashSet<String> set = new HashSet<String>();
        int i = 0;
        while (i < actions.length) {
            set.add(actions[i]);
            ++i;
        }
        if (set.contains(OK)) {
            return OK;
        }
        if (set.contains(FINISH)) {
            return FINISH;
        }
        if (set.contains(NEXT)) {
            return NEXT;
        }
        return null;
    }

    public final void startThread(Runnable task) {
        if (this.thread != null) {
            this.stopThread(true);
        }
        this.thread = new Thread(task);
        this.thread.start();
    }

    public final void stopThread(boolean force) {
        if (this.thread == null) {
            return;
        }
        if (this.thread.isAlive() && force) {
            this.thread.stop();
        }
        this.thread = null;
    }

    public String getHelpKey() {
        if (this.action == null) {
            return null;
        }
        String key = this.action.getProperty("key");
        if (key != null && key.length() > 0) {
            return key;
        }
        return String.valueOf(this.target.getModelEntity().getName()) + "_" + this.action.getName() + "_" + this.stepId;
    }

    public final XModelObject getTarget() {
        return this.target;
    }

    public final Properties getProperties() {
        if (this.p == null) {
            this.p = new Properties();
        }
        return this.p;
    }

    public boolean isActionEnabled(String name) {
        return true;
    }

    public boolean isFieldEditorEnabled(int stepId, String name, Properties values) {
        return true;
    }

    public WizardDataValidator getValidator(int step) {
        this.defaultValidator.setSupport(this, step);
        return this.defaultValidator;
    }

    public String getStepImplementingClass(int stepId) {
        return DEFAULT_IMLEMENTING_CLASS;
    }

    public Properties extractStepData(int index) throws RuntimeException {
        XEntityData d = this.getEntityData()[index];
        Properties p = DefaultCreateHandler.getProperties(d);
        XAttributeData[] ads = d.getAttributeData();
        int i = 0;
        while (i < ads.length) {
            String n = ads[i].getAttribute().getName();
            if (this.isFieldEditorEnabled(index, n, p)) {
                DefaultCreateHandler.extractProperty(ads[i]);
            }
            ++i;
        }
        return p;
    }

    public void initStepData(int index, XModelObject object) {
        XEntityData d = this.getEntityData()[index];
        XAttributeData[] ad = d.getAttributeData();
        int i = 0;
        while (i < ad.length) {
            String n = ad[i].getAttribute().getName();
            String v = object.getAttributeValue(n);
            if (v != null) {
                ad[i].setValue(v);
            }
            if ((v = this.action.getProperty("attribute." + n)) != null) {
                ad[i].setValue(v);
            }
            ++i;
        }
    }

    public final XAttributeData findAttribute(int index, String name) {
        return HUtil.find(this.getEntityData(), index, name);
    }

    public final String getAttributeValue(int index, String name) {
        XAttributeData d = this.findAttribute(index, name);
        return d != null ? d.getValue() : null;
    }

    public final void setAttributeValue(int index, String name, String value) {
        XAttributeData d = this.findAttribute(index, name);
        if (d != null) {
            d.setValue(value);
        }
    }

    public final void setValueList(int index, String name, String[] values) {
        HUtil.hackAttributeConstraintList(this.getEntityData(), index, name, values);
    }

    public final void setAttributeContext(int index, String name, Object context) {
        XAttributeData d = this.findAttribute(index, name);
        if (d != null) {
            d.getAttribute().getEditor().setContext(context);
        }
    }

    public final void setAttributeDataByObject(int index, XModelObject o) {
        XAttributeData[] ad = this.getEntityData()[0].getAttributeData();
        int i = 0;
        while (i < ad.length) {
            String n = ad[i].getAttribute().getName();
            String v = o.getAttributeValue(n);
            if (v != null) {
                this.setAttributeValue(0, n, v);
            }
            ++i;
        }
    }

    protected final void replaceEntityData(XEntityData d, int stepId) {
        if (this.data[stepId] == d) {
            return;
        }
        XAttributeData[] ad = d.getAttributeData();
        int i = 0;
        while (i < ad.length) {
            String n = ad[i].getAttribute().getName();
            String v = this.getAttributeValue(stepId, n);
            if (v == null) {
                v = ad[i].getAttribute().getDefaultValue();
            }
            if (v != null) {
                ad[i].setValue(v);
            }
            ++i;
        }
        this.data[stepId] = d;
    }

    public int getPreviousStepId() {
        return this.getStepId() - 1;
    }

    public String getFocusAttribute(int stepId) {
        XEntityData[] ds = this.getEntityData();
        if (ds == null || stepId < 0 || stepId >= ds.length) {
            return null;
        }
        XEntityData d = ds[stepId];
        XAttributeData[] ad = d.getAttributeData();
        if (ad.length == 0) {
            return null;
        }
        XAttributeData best = null;
        int importance = -1;
        int i = 0;
        while (i < ad.length && importance < 3) {
            int imp = ad[i].getMandatoryFlag() ? 1 : 0;
            if ((imp += ad[i].getValue() == null || ad[i].getValue().length() == 0 ? 2 : 0) > importance) {
                best = ad[i];
                importance = imp;
            }
            ++i;
        }
        return best == null ? null : best.getAttribute().getName();
    }

    public String getHelpContextId() {
        if (this.action == null) {
            return null;
        }
        String s = this.action.getProperty("helpId");
        if (s == null || s.length() == 0) {
            return null;
        }
        int i = s.indexOf(37);
        if (i < 0) {
            return s;
        }
        int j = s.indexOf(37, i + 1);
        if (j < 0) {
            return s;
        }
        String vr = s.substring(i + 1, j);
        String tail = s.substring(j + 1);
        XMapping map = this.action.getMetaModel().getMapping("HelpPlugins");
        if (map == null) {
            return s;
        }
        String varValue = map.getValue(vr);
        if (varValue == null) {
            return s;
        }
        return String.valueOf(varValue) + tail;
    }
}

