/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.dev.i18n;

import java.io.InputStream;
import java.util.Iterator;
import javax.inject.Inject;
import org.jboss.forge.dev.i18n.BundleCompleter;
import org.jboss.forge.parser.xml.Node;
import org.jboss.forge.parser.xml.XMLParser;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.facets.ResourceFacet;
import org.jboss.forge.resources.DirectoryResource;
import org.jboss.forge.resources.FileResource;
import org.jboss.forge.resources.PropertiesFileResource;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.resources.ResourceException;
import org.jboss.forge.resources.ResourceFilter;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.Command;
import org.jboss.forge.shell.plugins.Current;
import org.jboss.forge.shell.plugins.Help;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.PipeOut;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.RequiresProject;
import org.jboss.forge.shell.plugins.SetupCommand;
import org.jboss.forge.spec.javaee.FacesFacet;

@Alias(value="i18n")
@Help(value="Enables i18n support in a project. Deals with property resource bundle files.")
@RequiresProject
public class I18nPlugin
implements Plugin {
    @Inject
    @Current
    PropertiesFileResource propertiesFileResource;
    @Inject
    private Project project;
    @Inject
    private Shell shell;

    @SetupCommand(help="Configures a bundle for i18n operations")
    public void setupBundle(PipeOut out, @Option(name="bundleName", description="Bundle Name", defaultValue="messages") String bundleName) throws Exception {
        String fullBundleFile = bundleName.endsWith(".properties") ? bundleName : bundleName + ".properties";
        DirectoryResource resourceFolder = ((ResourceFacet)this.project.getFacet(ResourceFacet.class)).getResourceFolder();
        PropertiesFileResource bundleFile = (PropertiesFileResource)resourceFolder.getChildOfType(PropertiesFileResource.class, fullBundleFile);
        if (!bundleFile.exists()) {
            bundleFile.createNewFile();
        }
        this.shell.setCurrentResource((Resource)bundleFile);
        out.println("Bundle " + bundleFile + " has been created !");
        if (this.project.hasFacet(FacesFacet.class)) {
            this.shell.execute("i18n faces-setup");
        }
    }

    @Command(value="put", help="Adds or modifies an entry in this resource bundle")
    public void putProperty(@Option(name="key", required=true, completer=BundleCompleter.class) String key, @Option(name="value") String value, @Option(name="locale") String locale) {
        this.assertPropertiesInContext();
        if (locale == null) {
            this.propertiesFileResource.putProperty(key, value);
        } else {
            String bundleName = I18nPlugin.getBaseBundleName(this.propertiesFileResource.getName()) + "_" + locale + ".properties";
            PropertiesFileResource newFileResource = this.getOrCreate(bundleName);
            newFileResource.putProperty(key, value);
            this.shell.setCurrentResource((Resource)newFileResource);
        }
    }

    @Command(value="remove", help="Removes an entry in this resource bundle and all associated bundle locales")
    public void removeProperty(@Option(name="key", required=true, completer=BundleCompleter.class) String key, @Option(name="currentOnly", flagOnly=true, description="Delete only from current bundle") boolean currentOnly) {
        if (currentOnly) {
            this.propertiesFileResource.removeProperty(key);
        } else {
            String baseName = "messages";
            if (this.propertiesFileResource != null) {
                baseName = I18nPlugin.getBaseBundleName(this.propertiesFileResource.getName());
            }
            ResourceFacet resourceFacet = (ResourceFacet)this.project.getFacet(ResourceFacet.class);
            BundleBaseNameResourceFilter filter = new BundleBaseNameResourceFilter(baseName);
            for (DirectoryResource resourceFolder : resourceFacet.getResourceFolders()) {
                for (Resource r : resourceFolder.listResources((ResourceFilter)filter)) {
                    this.shell.println("Removing key \"" + key + "\" on bundle " + r.getFullyQualifiedName());
                    ((PropertiesFileResource)r).removeProperty(key);
                }
            }
        }
    }

    @Command(value="get", help="Adds or modifies an entry in this resource bundle")
    public void getProperty(@Option(name="key", required=true, completer=BundleCompleter.class) String key, @Option(name="locale") String locale) {
        this.assertPropertiesInContext();
        String propertyValue = null;
        if (locale == null) {
            propertyValue = this.propertiesFileResource.getProperty(key);
        } else {
            String bundleName = I18nPlugin.getBaseBundleName(this.propertiesFileResource.getName()) + "_" + locale + ".properties";
            PropertiesFileResource newFilePropertiesResource = this.getOrCreate(bundleName);
            propertyValue = newFilePropertiesResource.getProperty(key);
        }
        this.shell.println(propertyValue);
    }

    @Command(value="add-locale", help="Adds another locale in this resource bundle")
    public void addLocale(@Option(name="locale", required=true) String locale) {
        String baseName = "messages";
        if (this.propertiesFileResource != null) {
            baseName = I18nPlugin.getBaseBundleName(this.propertiesFileResource.getName());
        }
        String baseBundleName = baseName + "_" + locale + ".properties";
        PropertiesFileResource newFileResource = this.getOrCreate(baseBundleName);
        this.shell.setCurrentResource((Resource)newFileResource);
    }

    @Command(value="faces-setup", help="Setup this bundle as a ResourceBundle in faces-config.xml")
    public void setupFaces(@Option(name="var", description="The name by which this ResourceBundle instance is retrieved by a call to Application.getResourceBundle()", required=true, defaultValue="msg") String varName) {
        this.assertPropertiesInContext();
        FacesFacet facesFacet = (FacesFacet)this.project.getFacet(FacesFacet.class);
        FileResource configFile = facesFacet.getConfigFile();
        String baseBundleName = I18nPlugin.getBaseBundleName(this.propertiesFileResource.getName());
        Node facesConfig = XMLParser.parse((InputStream)configFile.getResourceInputStream());
        Node applicationNode = facesConfig.getOrCreate("application");
        Node resourceBundleNode = applicationNode.getOrCreate("resource-bundle");
        resourceBundleNode.getOrCreate("base-name").text(baseBundleName);
        resourceBundleNode.getOrCreate("var").text(varName);
        configFile.setContents(XMLParser.toXMLInputStream((Node)facesConfig));
        this.shell.println("Faces config has been updated.");
    }

    protected PropertiesFileResource getOrCreate(String bundleName) {
        ResourceFacet resourceFacet = (ResourceFacet)this.project.getFacet(ResourceFacet.class);
        BundleBaseNameResourceFilter filter = new BundleBaseNameResourceFilter(bundleName);
        PropertiesFileResource newFileResource = null;
        for (DirectoryResource directoryResource : resourceFacet.getResourceFolders()) {
            Iterator i$ = directoryResource.listResources((ResourceFilter)filter).iterator();
            if (!i$.hasNext()) continue;
            Resource resource = (Resource)i$.next();
            newFileResource = (PropertiesFileResource)resource;
        }
        if (newFileResource == null && !(newFileResource = (PropertiesFileResource)resourceFacet.getResourceFolder().getChildOfType(PropertiesFileResource.class, bundleName)).exists()) {
            newFileResource.createNewFile();
        }
        return newFileResource;
    }

    static String getBaseBundleName(String fileName) {
        String baseName = fileName.replace(".properties", "");
        int idxUnderscore = baseName.indexOf("_");
        if (idxUnderscore > -1) {
            baseName = baseName.substring(0, idxUnderscore);
        }
        return baseName;
    }

    private void assertPropertiesInContext() {
        if (this.propertiesFileResource == null) {
            throw new ResourceException("No bundle informed or in context");
        }
    }

    private class BundleBaseNameResourceFilter
    implements ResourceFilter {
        private String fileName;

        public BundleBaseNameResourceFilter(String fileName) {
            this.fileName = fileName;
        }

        public boolean accept(Resource<?> resource) {
            return resource instanceof PropertiesFileResource && resource.getName().startsWith(this.fileName);
        }
    }
}

