/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.parser.java.impl;

import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jface.text.Document;
import org.jboss.forge.parser.java.JavaClass;
import org.jboss.forge.parser.java.Method;
import org.jboss.forge.parser.java.SourceType;
import org.jboss.forge.parser.java.ast.ModifierAccessor;
import org.jboss.forge.parser.java.impl.AbstractJavaSourceMemberHolder;
import org.jboss.forge.parser.java.util.Types;

public class JavaClassImpl
extends AbstractJavaSourceMemberHolder<JavaClass>
implements JavaClass {
    private final ModifierAccessor modifiers = new ModifierAccessor();

    public JavaClassImpl(Document document, CompilationUnit unit) {
        super(document, unit);
    }

    @Override
    protected JavaClass updateTypeNames(String newName) {
        for (Method m : this.getMethods()) {
            if (!m.isConstructor()) continue;
            m.setConstructor(false);
            m.setConstructor(true);
        }
        return this;
    }

    public boolean isAbstract() {
        return this.modifiers.hasModifier((BodyDeclaration)this.getBodyDeclaration(), Modifier.ModifierKeyword.ABSTRACT_KEYWORD);
    }

    public JavaClass setAbstract(boolean abstrct) {
        if (abstrct) {
            this.modifiers.addModifier((BodyDeclaration)this.getBodyDeclaration(), Modifier.ModifierKeyword.ABSTRACT_KEYWORD);
        } else {
            this.modifiers.removeModifier((BodyDeclaration)this.getBodyDeclaration(), Modifier.ModifierKeyword.ABSTRACT_KEYWORD);
        }
        return this;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.toString() == null ? 0 : this.unit.toString().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj != null && this.getClass() == obj.getClass() && this.toString().equals(obj.toString());
    }

    public String getSuperType() {
        Object superType = this.getBodyDeclaration().getStructuralProperty((StructuralPropertyDescriptor)TypeDeclaration.SUPERCLASS_TYPE_PROPERTY);
        if (superType == null) {
            superType = Object.class.getName();
        }
        return this.resolveType(superType.toString());
    }

    public JavaClass setSuperType(JavaClass type) {
        return this.setSuperType(type.getQualifiedName());
    }

    public JavaClass setSuperType(Class<?> type) {
        if (type.isAnnotation() || type.isEnum() || type.isInterface() || type.isPrimitive()) {
            throw new IllegalArgumentException("Super-type must be a Class type, but was [" + type.getName() + "]");
        }
        return this.setSuperType(type.getName());
    }

    public JavaClass setSuperType(String type) {
        SimpleType simpleType = this.unit.getAST().newSimpleType((Name)this.unit.getAST().newSimpleName(Types.toSimpleName((String)type)));
        this.getBodyDeclaration().setStructuralProperty((StructuralPropertyDescriptor)TypeDeclaration.SUPERCLASS_TYPE_PROPERTY, (Object)simpleType);
        if (!this.hasImport(type) && Types.isQualified((String)type)) {
            this.addImport(type);
        }
        return this;
    }

    public SourceType getSourceType() {
        return SourceType.CLASS;
    }
}

