/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.parser.java.impl;

import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.jboss.forge.parser.JavaParser;
import org.jboss.forge.parser.java.Annotation;
import org.jboss.forge.parser.java.AnnotationTarget;
import org.jboss.forge.parser.java.Field;
import org.jboss.forge.parser.java.JavaClass;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.forge.parser.java.Type;
import org.jboss.forge.parser.java.Visibility;
import org.jboss.forge.parser.java.VisibilityScoped;
import org.jboss.forge.parser.java.ast.AnnotationAccessor;
import org.jboss.forge.parser.java.ast.ModifierAccessor;
import org.jboss.forge.parser.java.impl.TypeImpl;
import org.jboss.forge.parser.java.util.Strings;
import org.jboss.forge.parser.java.util.Types;

public class FieldImpl<O extends JavaSource<O>>
implements Field<O> {
    private final AnnotationAccessor<O, Field<O>> annotations = new AnnotationAccessor();
    private final ModifierAccessor modifiers = new ModifierAccessor();
    private O parent;
    private AST ast;
    private final FieldDeclaration field;

    private void init(O parent) {
        this.parent = parent;
        this.ast = ((ASTNode)parent.getInternal()).getAST();
    }

    public FieldImpl(O parent) {
        this.init(parent);
        this.field = this.ast.newFieldDeclaration(this.ast.newVariableDeclarationFragment());
    }

    public FieldImpl(O parent, String declaration) {
        FieldDeclaration subtree;
        this.init(parent);
        String stub = "public class Stub { " + declaration + " }";
        JavaClass temp = (JavaClass)JavaParser.parse((String)stub);
        List fields = temp.getFields();
        FieldDeclaration newField = (FieldDeclaration)((Field)fields.get(0)).getInternal();
        this.field = subtree = (FieldDeclaration)ASTNode.copySubtree((AST)this.ast, (ASTNode)newField);
    }

    public FieldImpl(O parent, Object internal) {
        this.init(parent);
        this.field = (FieldDeclaration)internal;
    }

    public O getOrigin() {
        return (O)((JavaSource)this.parent.getOrigin());
    }

    public Object getInternal() {
        return this.field;
    }

    public Annotation<O> addAnnotation() {
        return this.annotations.addAnnotation((AnnotationTarget<O, Field<O>>)this, (BodyDeclaration)this.field);
    }

    public Annotation<O> addAnnotation(Class<? extends java.lang.annotation.Annotation> clazz) {
        if (this.parent.requiresImport(clazz)) {
            this.parent.addImport(clazz);
        }
        return this.annotations.addAnnotation((AnnotationTarget<O, Field<O>>)this, (BodyDeclaration)this.field, clazz.getSimpleName());
    }

    public Annotation<O> addAnnotation(String className) {
        return this.annotations.addAnnotation((AnnotationTarget<O, Field<O>>)this, (BodyDeclaration)this.field, className);
    }

    public List<Annotation<O>> getAnnotations() {
        return this.annotations.getAnnotations((AnnotationTarget<O, Field<O>>)this, (BodyDeclaration)this.field);
    }

    public boolean hasAnnotation(Class<? extends java.lang.annotation.Annotation> type) {
        return this.annotations.hasAnnotation(this, (BodyDeclaration)this.field, type.getName());
    }

    public boolean hasAnnotation(String type) {
        return this.annotations.hasAnnotation(this, (BodyDeclaration)this.field, type);
    }

    public Annotation<O> getAnnotation(Class<? extends java.lang.annotation.Annotation> type) {
        return this.annotations.getAnnotation((AnnotationTarget<O, Field<O>>)this, (BodyDeclaration)this.field, (Class<java.lang.annotation.Annotation>)type);
    }

    public Annotation<O> getAnnotation(String type) {
        return this.annotations.getAnnotation((AnnotationTarget<O, Field<O>>)this, (BodyDeclaration)this.field, type);
    }

    public Field<O> removeAnnotation(Annotation<O> annotation) {
        return this.annotations.removeAnnotation(this, (BodyDeclaration)this.field, annotation);
    }

    public String toString() {
        return this.field.toString();
    }

    public boolean isFinal() {
        return this.modifiers.hasModifier((BodyDeclaration)this.field, Modifier.ModifierKeyword.FINAL_KEYWORD);
    }

    public Field<O> setFinal(boolean finl) {
        if (finl) {
            this.modifiers.addModifier((BodyDeclaration)this.field, Modifier.ModifierKeyword.FINAL_KEYWORD);
        } else {
            this.modifiers.removeModifier((BodyDeclaration)this.field, Modifier.ModifierKeyword.FINAL_KEYWORD);
        }
        return this;
    }

    public boolean isStatic() {
        return this.modifiers.hasModifier((BodyDeclaration)this.field, Modifier.ModifierKeyword.STATIC_KEYWORD);
    }

    public Field<O> setStatic(boolean statc) {
        if (statc) {
            this.modifiers.addModifier((BodyDeclaration)this.field, Modifier.ModifierKeyword.STATIC_KEYWORD);
        } else {
            this.modifiers.removeModifier((BodyDeclaration)this.field, Modifier.ModifierKeyword.STATIC_KEYWORD);
        }
        return this;
    }

    public boolean isPackagePrivate() {
        return !this.isPublic() && !this.isPrivate() && !this.isProtected();
    }

    public Field<O> setPackagePrivate() {
        this.modifiers.clearVisibility((BodyDeclaration)this.field);
        return this;
    }

    public boolean isPublic() {
        return this.modifiers.hasModifier((BodyDeclaration)this.field, Modifier.ModifierKeyword.PUBLIC_KEYWORD);
    }

    public Field<O> setPublic() {
        this.modifiers.clearVisibility((BodyDeclaration)this.field);
        this.modifiers.addModifier((BodyDeclaration)this.field, Modifier.ModifierKeyword.PUBLIC_KEYWORD);
        return this;
    }

    public boolean isPrivate() {
        return this.modifiers.hasModifier((BodyDeclaration)this.field, Modifier.ModifierKeyword.PRIVATE_KEYWORD);
    }

    public Field<O> setPrivate() {
        this.modifiers.clearVisibility((BodyDeclaration)this.field);
        this.modifiers.addModifier((BodyDeclaration)this.field, Modifier.ModifierKeyword.PRIVATE_KEYWORD);
        return this;
    }

    public boolean isProtected() {
        return this.modifiers.hasModifier((BodyDeclaration)this.field, Modifier.ModifierKeyword.PROTECTED_KEYWORD);
    }

    public Field<O> setProtected() {
        this.modifiers.clearVisibility((BodyDeclaration)this.field);
        this.modifiers.addModifier((BodyDeclaration)this.field, Modifier.ModifierKeyword.PROTECTED_KEYWORD);
        return this;
    }

    public Visibility getVisibility() {
        return Visibility.getFrom((VisibilityScoped)this);
    }

    public Field<O> setVisibility(Visibility scope) {
        return (Field)Visibility.set((VisibilityScoped)this, (Visibility)scope);
    }

    public String getName() {
        String result = null;
        for (Object f : this.field.fragments()) {
            if (!(f instanceof VariableDeclarationFragment)) continue;
            VariableDeclarationFragment frag = (VariableDeclarationFragment)f;
            result = frag.getName().getFullyQualifiedName();
            break;
        }
        return result;
    }

    public Field<O> setName(String name) {
        for (Object f : this.field.fragments()) {
            if (!(f instanceof VariableDeclarationFragment)) continue;
            VariableDeclarationFragment frag = (VariableDeclarationFragment)f;
            frag.setName(this.ast.newSimpleName(name));
            break;
        }
        return this;
    }

    public String getType() {
        return Types.toSimpleName((String)this.getQualifiedType());
    }

    public String getQualifiedType() {
        Object type = this.field.getStructuralProperty((StructuralPropertyDescriptor)FieldDeclaration.TYPE_PROPERTY);
        return this.parent.resolveType(type.toString());
    }

    public Type<O> getTypeInspector() {
        return new TypeImpl<O>(this.parent, this.field.getStructuralProperty((StructuralPropertyDescriptor)FieldDeclaration.TYPE_PROPERTY));
    }

    public boolean isType(Class<?> type) {
        if (Strings.areEqual((String)type.getName(), (String)this.getQualifiedType())) {
            return true;
        }
        if (this.isPrimitive() && type.getSimpleName().equals(this.getType())) {
            return true;
        }
        String simpleName = type.getSimpleName();
        return Strings.areEqual((String)simpleName, (String)this.getQualifiedType()) && (this.getOrigin().hasImport(type) || !this.getOrigin().requiresImport(type));
    }

    public boolean isType(String name) {
        if (Strings.areEqual((String)name, (String)this.getQualifiedType())) {
            return true;
        }
        return (!Types.isQualified((String)name) || this.getOrigin().hasImport(name) || !this.getOrigin().requiresImport(name)) && Types.areEquivalent((String)name, (String)this.getQualifiedType());
    }

    public Field<O> setType(Class<?> clazz) {
        if (this.parent.requiresImport(clazz)) {
            this.parent.addImport(clazz);
        }
        return this.setType(clazz.getSimpleName());
    }

    public Field<O> setType(JavaSource<?> source) {
        return this.setType(source.getQualifiedName());
    }

    public Field<O> setType(String typeName) {
        String simpleName = Types.toSimpleName((String)typeName);
        O origin = this.getOrigin();
        if (!Strings.areEqual((String)typeName, (String)simpleName) && origin.requiresImport(typeName)) {
            origin.addImport(typeName);
        }
        PrimitiveType.Code primitive = PrimitiveType.toCode((String)typeName);
        PrimitiveType type = null;
        if (primitive != null) {
            type = this.ast.newPrimitiveType(primitive);
        } else if (!origin.requiresImport(typeName)) {
            SimpleName name = this.ast.newSimpleName(simpleName);
            type = this.ast.newSimpleType((Name)name);
        } else {
            String[] className = Types.tokenizeClassName((String)typeName);
            Name name = this.ast.newName(className);
            type = this.ast.newSimpleType(name);
        }
        this.field.setType((org.eclipse.jdt.core.dom.Type)type);
        return this;
    }

    public String getLiteralInitializer() {
        String result = null;
        for (Object f : this.field.fragments()) {
            if (!(f instanceof VariableDeclarationFragment)) continue;
            VariableDeclarationFragment frag = (VariableDeclarationFragment)f;
            result = frag.getInitializer().toString();
            break;
        }
        return result;
    }

    public String getStringInitializer() {
        String result = null;
        for (Object f : this.field.fragments()) {
            if (!(f instanceof VariableDeclarationFragment)) continue;
            VariableDeclarationFragment frag = (VariableDeclarationFragment)f;
            result = Strings.unquote((String)frag.getInitializer().toString());
            break;
        }
        return result;
    }

    public Field<O> setLiteralInitializer(String value) {
        String stub = "public class Stub { private Field<O> stub = " + value + " }";
        JavaClass temp = (JavaClass)JavaParser.parse((String)stub);
        FieldDeclaration internal = (FieldDeclaration)((Field)temp.getFields().get(0)).getInternal();
        for (Object f : internal.fragments()) {
            if (!(f instanceof VariableDeclarationFragment)) continue;
            VariableDeclarationFragment tempFrag = (VariableDeclarationFragment)f;
            VariableDeclarationFragment localFrag = this.getFragment(this.field);
            localFrag.setInitializer((Expression)ASTNode.copySubtree((AST)this.ast, (ASTNode)tempFrag.getInitializer()));
            break;
        }
        return this;
    }

    public Field<O> setStringInitializer(String value) {
        return this.setLiteralInitializer(Strings.enquote((String)value));
    }

    private VariableDeclarationFragment getFragment(FieldDeclaration field) {
        VariableDeclarationFragment result = null;
        for (Object f : field.fragments()) {
            if (!(f instanceof VariableDeclarationFragment)) continue;
            result = (VariableDeclarationFragment)f;
            break;
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.field == null ? 0 : this.field.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FieldImpl other = (FieldImpl)obj;
        return !(this.field == null ? other.field != null : !this.field.equals((Object)other.field));
    }

    public boolean isPrimitive() {
        boolean result = false;
        org.eclipse.jdt.core.dom.Type type = this.field.getType();
        if (type != null) {
            result = type.isPrimitiveType();
        }
        return result;
    }
}

