/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.scanners.index;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.sonatype.guice.bean.reflect.URLClassSpace;
import org.sonatype.guice.bean.scanners.ClassSpaceScanner;
import org.sonatype.guice.bean.scanners.QualifiedTypeListener;
import org.sonatype.guice.bean.scanners.QualifiedTypeVisitor;
import org.sonatype.guice.bean.scanners.index.AbstractSisuIndex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class QualifiedIndexCmd
extends AbstractSisuIndex
implements QualifiedTypeListener {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws MalformedURLException {
        URL[] urls = new URL[args.length];
        for (int i = 0; i < args.length; ++i) {
            urls[i] = new File(args[i]).toURI().toURL();
        }
        QualifiedIndexCmd indexer = new QualifiedIndexCmd();
        try {
            ClassLoader parent = QualifiedIndexCmd.class.getClassLoader();
            ClassLoader loader = urls.length > 0 ? URLClassLoader.newInstance(urls, parent) : parent;
            new ClassSpaceScanner(new URLClassSpace(loader)).accept(new QualifiedTypeVisitor(indexer));
        }
        finally {
            indexer.flushIndex();
        }
    }

    @Override
    public void hear(Annotation qualifier, Class<?> qualifiedType, Object source) {
        this.addClassToIndex(qualifier.annotationType().getName(), qualifiedType.getName());
    }

    @Override
    protected void info(String message) {
        System.out.println("[INFO] " + message);
    }

    @Override
    protected void warn(String message) {
        System.out.println("[WARN] " + message);
    }

    @Override
    protected Reader getReader(String path) throws IOException {
        return new FileReader(path);
    }

    @Override
    protected Writer getWriter(String path) throws IOException {
        File index = new File(path);
        File parent = index.getParentFile();
        if (parent.isDirectory() || parent.mkdirs()) {
            return new FileWriter(index, true);
        }
        throw new IOException("Error creating: " + parent);
    }
}

