/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.template.textformating;

import java.util.ArrayList;
import java.util.List;
import org.jboss.tools.vpe.editor.template.VpeTemplateManager;
import org.jboss.tools.vpe.editor.template.textformating.FormatData;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TextFormatingData {
    private FormatData[] formats;

    public TextFormatingData(Element templateTextFormatingElement) {
        NodeList list = templateTextFormatingElement.getElementsByTagName("vpe:format");
        ArrayList<FormatData> defaultFormats = new ArrayList<FormatData>();
        if ("yes".equals(templateTextFormatingElement.getAttribute("use-default-formats"))) {
            FormatData[] formats;
            FormatData[] formatDataArray = formats = VpeTemplateManager.getDefaultTextFormattingData().getAllFormatData();
            int n = formats.length;
            int n2 = 0;
            while (n2 < n) {
                FormatData formatData = formatDataArray[n2];
                defaultFormats.add(formatData);
                ++n2;
            }
        }
        ArrayList<FormatData> localFormats = new ArrayList<FormatData>();
        int i = 0;
        while (i < list.getLength()) {
            Element element = (Element)list.item(i);
            localFormats.add(new FormatData(element));
            ++i;
        }
        this.formats = this.mergeLocalAndDefaultFormats(defaultFormats, localFormats).toArray(new FormatData[0]);
    }

    private List<FormatData> mergeLocalAndDefaultFormats(List<FormatData> defaultFormats, List<FormatData> localFormats) {
        ArrayList<FormatData> result = new ArrayList<FormatData>(localFormats);
        for (FormatData formatData : defaultFormats) {
            if (this.isFormatExistInList(result, formatData)) continue;
            result.add(formatData);
        }
        return result;
    }

    private boolean isFormatExistInList(List<FormatData> formatData, FormatData data) {
        if (data.getType() == null) {
            return false;
        }
        for (FormatData format : formatData) {
            if (!data.getType().equals(format.getType())) continue;
            return true;
        }
        return false;
    }

    public FormatData[] getAllFormatData() {
        return this.formats;
    }

    public FormatData[] getFormatDatas(String type) {
        ArrayList<FormatData> result = new ArrayList<FormatData>();
        int i = 0;
        while (i < this.formats.length) {
            if (type.equals(this.formats[i].getType())) {
                result.add(this.formats[i]);
            }
            ++i;
        }
        return result.toArray(new FormatData[0]);
    }

    public boolean hasFormatData(String type) {
        return this.getFormatDatas(type).length > 0;
    }
}

