/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.swing.widgetprocessor.binding.beansbinding;

import org.jdesktop.beansbinding.Converter;
import org.metawidget.widgetprocessor.iface.WidgetProcessorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NumberConverter<T extends Number>
extends Converter<T, String> {
    private Class<? extends Number> mNumberClass;

    public NumberConverter(Class<? extends T> numberClass) {
        this.mNumberClass = numberClass;
    }

    public String convertForward(Number value) {
        return String.valueOf(value);
    }

    public T convertReverse(String value) {
        if (value == null || value.trim().length() == 0) {
            return null;
        }
        if (this.mNumberClass.equals(Byte.class)) {
            return (T)Byte.valueOf(value);
        }
        if (this.mNumberClass.equals(Short.class)) {
            return (T)Short.valueOf(value);
        }
        if (this.mNumberClass.equals(Integer.class)) {
            return (T)Integer.valueOf(value);
        }
        if (this.mNumberClass.equals(Long.class)) {
            return (T)Long.valueOf(value);
        }
        if (this.mNumberClass.equals(Float.class)) {
            return (T)Float.valueOf(value);
        }
        if (this.mNumberClass.equals(Double.class)) {
            return (T)Double.valueOf(value);
        }
        throw WidgetProcessorException.newException("Unknown type " + this.mNumberClass);
    }
}

