/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.faces.component.html.widgetbuilder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.application.Application;
import javax.faces.component.UIColumn;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.UISelectItem;
import javax.faces.component.UISelectItems;
import javax.faces.component.UISelectMany;
import javax.faces.component.UIViewRoot;
import javax.faces.component.ValueHolder;
import javax.faces.component.html.HtmlCommandLink;
import javax.faces.component.html.HtmlDataTable;
import javax.faces.component.html.HtmlInputSecret;
import javax.faces.component.html.HtmlInputText;
import javax.faces.component.html.HtmlInputTextarea;
import javax.faces.component.html.HtmlOutputText;
import javax.faces.component.html.HtmlSelectManyCheckbox;
import javax.faces.component.html.HtmlSelectOneMenu;
import javax.faces.component.html.HtmlSelectOneRadio;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.el.MethodBinding;
import javax.faces.model.DataModel;
import javax.faces.model.SelectItem;
import org.metawidget.faces.FacesUtils;
import org.metawidget.faces.component.UIMetawidget;
import org.metawidget.faces.component.html.HtmlMetawidget;
import org.metawidget.faces.component.html.widgetbuilder.HtmlWidgetBuilderConfig;
import org.metawidget.faces.component.widgetprocessor.ConverterProcessor;
import org.metawidget.faces.component.widgetprocessor.StandardBindingProcessor;
import org.metawidget.util.ArrayUtils;
import org.metawidget.util.ClassUtils;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.WidgetBuilderUtils;
import org.metawidget.util.XmlUtils;
import org.metawidget.util.simple.StringUtils;
import org.metawidget.widgetbuilder.iface.WidgetBuilder;
import org.metawidget.widgetbuilder.iface.WidgetBuilderException;
import org.metawidget.widgetprocessor.iface.WidgetProcessor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlWidgetBuilder
implements WidgetBuilder<UIComponent, UIMetawidget> {
    private static final String DATATABLE_ROW_ACTION = "dataTableRowAction";
    private static final int SHORT_LOOKUP_SIZE = 3;
    private final String mDataTableStyleClass;
    private final String[] mDataTableColumnClasses;
    private final String[] mDataTableRowClasses;
    private final int mMaximumColumnsInDataTable;

    public HtmlWidgetBuilder() {
        this(new HtmlWidgetBuilderConfig());
    }

    public HtmlWidgetBuilder(HtmlWidgetBuilderConfig config) {
        this.mDataTableStyleClass = config.getDataTableStyleClass();
        this.mDataTableColumnClasses = config.getDataTableColumnClasses();
        this.mDataTableRowClasses = config.getDataTableRowClasses();
        this.mMaximumColumnsInDataTable = config.getMaximumColumnsInDataTable();
    }

    @Override
    public UIComponent buildWidget(String elementName, Map<String, String> attributes, UIMetawidget metawidget) {
        FacesContext context = FacesContext.getCurrentInstance();
        Application application = context.getApplication();
        if ("true".equals(attributes.get("hidden"))) {
            return application.createComponent("org.metawidget.Stub");
        }
        UIComponent component = null;
        String componentName = attributes.get("faces-component");
        if (componentName != null) {
            component = application.createComponent(componentName);
        }
        if ("action".equals(elementName)) {
            if (component == null) {
                component = application.createComponent("javax.faces.HtmlCommandButton");
            }
            ((UICommand)component).setValue((Object)metawidget.getLabelString(attributes));
            return component;
        }
        String type = WidgetBuilderUtils.getActualClassOrType(attributes);
        if (type == null) {
            type = String.class.getName();
        }
        Class<?> clazz = ClassUtils.niceForName(type);
        String facesLookup = attributes.get("faces-lookup");
        if (facesLookup != null && !"".equals(facesLookup)) {
            if (component == null) {
                component = clazz != null && (List.class.isAssignableFrom(clazz) || clazz.isArray()) ? application.createComponent("javax.faces.HtmlSelectManyCheckbox") : application.createComponent("javax.faces.HtmlSelectOneMenu");
            }
            this.initFacesSelect(component, facesLookup, attributes, metawidget);
            return component;
        }
        if (clazz != null) {
            if (component == null && Boolean.class.equals(clazz) && "true".equals(attributes.get("required"))) {
                return application.createComponent("javax.faces.HtmlSelectBooleanCheckbox");
            }
            String lookup = attributes.get("lookup");
            if (lookup != null && !"".equals(lookup)) {
                if (component == null) {
                    component = List.class.isAssignableFrom(clazz) || clazz.isArray() ? application.createComponent("javax.faces.HtmlSelectManyCheckbox") : application.createComponent("javax.faces.HtmlSelectOneMenu");
                }
                this.initStaticSelect(component, lookup, clazz, attributes, metawidget);
            }
            if (component == null) {
                if (Boolean.TYPE.equals(clazz)) {
                    component = application.createComponent("javax.faces.HtmlSelectBooleanCheckbox");
                } else if (Character.TYPE.equals(clazz) || Character.class.isAssignableFrom(clazz)) {
                    component = application.createComponent("javax.faces.HtmlInputText");
                    ((HtmlInputText)component).setMaxlength(1);
                } else if (clazz.isPrimitive()) {
                    component = application.createComponent("javax.faces.HtmlInputText");
                } else if (Date.class.isAssignableFrom(clazz)) {
                    component = application.createComponent("javax.faces.HtmlInputText");
                } else if (Number.class.isAssignableFrom(clazz)) {
                    component = application.createComponent("javax.faces.HtmlInputText");
                } else if (String.class.equals(clazz)) {
                    if ("true".equals(attributes.get("masked"))) {
                        component = application.createComponent("javax.faces.HtmlInputSecret");
                    } else if ("true".equals(attributes.get("large"))) {
                        component = application.createComponent("javax.faces.HtmlInputTextarea");
                        ((HtmlInputTextarea)component).setCols(20);
                        ((HtmlInputTextarea)component).setRows(2);
                    } else {
                        component = application.createComponent("javax.faces.HtmlInputText");
                    }
                } else {
                    if (List.class.isAssignableFrom(clazz) || DataModel.class.isAssignableFrom(clazz) || clazz.isArray()) {
                        return this.createDataTableComponent(elementName, attributes, metawidget);
                    }
                    if (Collection.class.isAssignableFrom(clazz)) {
                        return application.createComponent("org.metawidget.Stub");
                    }
                }
            }
            this.setMaximumLength(component, attributes);
            if (component != null) {
                return component;
            }
        }
        if ("true".equals(attributes.get("dont-expand"))) {
            return application.createComponent("javax.faces.HtmlInputText");
        }
        return null;
    }

    protected void initFacesSelect(UIComponent component, String facesLookup, Map<String, String> attributes, UIMetawidget metawidget) {
        if (component instanceof HtmlSelectManyCheckbox) {
            ((HtmlSelectManyCheckbox)component).setLayout("pageDirection");
        } else if (component instanceof HtmlSelectOneRadio) {
            ((HtmlSelectOneRadio)component).setLayout("pageDirection");
        }
        this.addSelectItems(component, facesLookup, attributes, metawidget);
    }

    protected void initStaticSelect(UIComponent component, String lookup, Class<?> clazz, Map<String, String> attributes, UIMetawidget metawidget) {
        FacesContext context = FacesContext.getCurrentInstance();
        Application application = context.getApplication();
        List<String> values = CollectionUtils.fromString(lookup);
        if (values.size() > 3) {
            if (component instanceof HtmlSelectManyCheckbox) {
                ((HtmlSelectManyCheckbox)component).setLayout("pageDirection");
            } else if (component instanceof HtmlSelectOneRadio) {
                ((HtmlSelectOneRadio)component).setLayout("pageDirection");
            }
        }
        List<String> valuesAfterConversion = values;
        if (component instanceof ValueHolder) {
            Converter converter = null;
            ConverterProcessor processor = metawidget.getWidgetProcessor(ConverterProcessor.class);
            if (processor != null) {
                converter = processor.getConverter((ValueHolder)component, attributes);
            }
            if (converter == null && !(component instanceof UISelectMany)) {
                converter = application.createConverter(clazz);
            }
            if (converter != null) {
                int size = valuesAfterConversion.size();
                ArrayList convertedValues = CollectionUtils.newArrayList(size);
                for (int loop = 0; loop < size; ++loop) {
                    Object convertedValue = converter.getAsObject(context, component, values.get(loop));
                    convertedValues.add(convertedValue);
                }
                valuesAfterConversion = convertedValues;
            }
        }
        this.addSelectItems(component, valuesAfterConversion, CollectionUtils.fromString(attributes.get("lookup-labels")), attributes, metawidget);
    }

    protected void setMaximumLength(UIComponent component, Map<String, String> attributes) {
        String maximumLength = attributes.get("maximum-length");
        if (maximumLength != null && !"".equals(maximumLength)) {
            if (component instanceof HtmlInputText) {
                ((HtmlInputText)component).setMaxlength(Integer.parseInt(maximumLength));
            } else if (component instanceof HtmlInputSecret) {
                ((HtmlInputSecret)component).setMaxlength(Integer.parseInt(maximumLength));
            }
        }
    }

    protected UIComponent createDataTableComponent(String elementName, Map<String, String> attributes, UIMetawidget metawidget) {
        NodeList elements;
        FacesContext context = FacesContext.getCurrentInstance();
        Application application = context.getApplication();
        UIViewRoot viewRoot = context.getViewRoot();
        HtmlDataTable dataTable = (HtmlDataTable)application.createComponent("javax.faces.HtmlDataTable");
        dataTable.setVar("_item");
        dataTable.setStyleClass(this.mDataTableStyleClass);
        dataTable.setColumnClasses(ArrayUtils.toString(this.mDataTableColumnClasses));
        dataTable.setRowClasses(ArrayUtils.toString(this.mDataTableRowClasses));
        String componentType = WidgetBuilderUtils.getComponentType(attributes);
        String inspectedType = null;
        if (componentType != null) {
            inspectedType = metawidget.inspect(null, componentType, new String[0]);
        }
        if (inspectedType == null) {
            elements = null;
        } else {
            Element root = XmlUtils.documentFromString(inspectedType).getDocumentElement();
            elements = root.getFirstChild().getChildNodes();
        }
        if (elements == null || elements.getLength() == 0) {
            HashMap<String, String> columnAttributes = CollectionUtils.newHashMap();
            columnAttributes.put("name", attributes.get("name"));
            this.addColumnComponent((UIData)dataTable, attributes, "entity", columnAttributes, metawidget);
        } else {
            this.addColumnComponents((UIData)dataTable, attributes, elements, metawidget);
        }
        String rowActionParameter = metawidget.getParameter(DATATABLE_ROW_ACTION);
        if (rowActionParameter != null) {
            HtmlCommandLink rowAction = (HtmlCommandLink)application.createComponent("javax.faces.HtmlCommandLink");
            rowAction.setId(viewRoot.createUniqueId());
            if (FacesUtils.isExpression(rowActionParameter)) {
                throw WidgetBuilderException.newException("dataTableRowAction must be an unwrapped JSF expression (eg. foo.bar, not #{foo.bar})");
            }
            String actionName = StringUtils.substringAfterLast(rowActionParameter, ".");
            String localizedKey = metawidget.getLocalizedKey(actionName);
            if (localizedKey == null) {
                rowAction.setValue((Object)StringUtils.uncamelCase(actionName));
            } else {
                rowAction.setValue((Object)localizedKey);
            }
            MethodBinding binding = application.createMethodBinding(FacesUtils.wrapExpression(rowActionParameter), null);
            rowAction.setAction(binding);
            UIColumn column = (UIColumn)application.createComponent("javax.faces.HtmlColumn");
            column.setId(viewRoot.createUniqueId());
            column.getChildren().add(rowAction);
            dataTable.getChildren().add(column);
            HtmlOutputText headerText = (HtmlOutputText)application.createComponent("javax.faces.HtmlOutputText");
            headerText.setId(viewRoot.createUniqueId());
            headerText.setValue((Object)"<div></div>");
            headerText.setEscape(false);
            column.setHeader((UIComponent)headerText);
        }
        return dataTable;
    }

    protected void addColumnComponents(UIData dataTable, Map<String, String> attributes, NodeList elements, UIMetawidget metawidget) {
        boolean onlyRequired = true;
        while (true) {
            int length = elements.getLength();
            for (int loop = 0; loop < length; ++loop) {
                Element element;
                Node node = elements.item(loop);
                if (!(node instanceof Element) || "action".equals((element = (Element)node).getNodeName()) || "true".equals(element.getAttribute("hidden")) || onlyRequired && !"true".equals(element.getAttribute("required"))) continue;
                this.addColumnComponent(dataTable, attributes, "property", XmlUtils.getAttributesAsMap(element), metawidget);
                if (dataTable.getChildren().size() == this.mMaximumColumnsInDataTable) break;
            }
            if (!dataTable.getChildren().isEmpty() || !onlyRequired) break;
            onlyRequired = false;
        }
    }

    protected void addColumnComponent(UIData dataTable, Map<String, String> tableAttributes, String elementName, Map<String, String> columnAttributes, UIMetawidget metawidget) {
        WidgetProcessor converterProcessor;
        FacesContext context = FacesContext.getCurrentInstance();
        Application application = context.getApplication();
        UIViewRoot viewRoot = context.getViewRoot();
        UIColumn column = (UIColumn)application.createComponent("javax.faces.HtmlColumn");
        column.setId(viewRoot.createUniqueId());
        UIComponent columnText = application.createComponent("javax.faces.HtmlOutputText");
        columnText.setId(viewRoot.createUniqueId());
        HtmlMetawidget dummyMetawidget = new HtmlMetawidget();
        dummyMetawidget.setValueBinding("value", application.createValueBinding(FacesUtils.wrapExpression(dataTable.getVar())));
        WidgetProcessor bindingProcessor = metawidget.getWidgetProcessor(StandardBindingProcessor.class);
        if (bindingProcessor != null) {
            bindingProcessor.processWidget(columnText, elementName, columnAttributes, dummyMetawidget);
        }
        if ((converterProcessor = (WidgetProcessor)((Object)metawidget.getWidgetProcessor(ConverterProcessor.class))) != null) {
            converterProcessor.processWidget(columnText, elementName, columnAttributes, dummyMetawidget);
        }
        column.getChildren().add(columnText);
        HtmlOutputText headerText = (HtmlOutputText)application.createComponent("javax.faces.HtmlOutputText");
        headerText.setId(viewRoot.createUniqueId());
        headerText.setValue((Object)metawidget.getLabelString(columnAttributes));
        column.setHeader((UIComponent)headerText);
        dataTable.getChildren().add(column);
    }

    private void addSelectItems(UIComponent component, List<?> values, List<String> labels, Map<String, String> attributes, UIMetawidget metawidget) {
        if (values == null) {
            return;
        }
        if (component instanceof HtmlSelectOneMenu && WidgetBuilderUtils.needsEmptyLookupItem(attributes)) {
            this.addSelectItem(component, null, null, metawidget);
        }
        if (labels != null && !labels.isEmpty() && labels.size() != values.size()) {
            throw WidgetBuilderException.newException("Labels list must be same size as values list");
        }
        int length = values.size();
        for (int loop = 0; loop < length; ++loop) {
            Object value = values.get(loop);
            String label = null;
            if (labels != null && !labels.isEmpty()) {
                label = labels.get(loop);
            }
            this.addSelectItem(component, value, label, metawidget);
        }
    }

    private void addSelectItem(UIComponent component, Object value, String label, UIMetawidget metawidget) {
        FacesContext context = FacesContext.getCurrentInstance();
        Application application = context.getApplication();
        UISelectItem selectItem = (UISelectItem)application.createComponent("javax.faces.SelectItem");
        selectItem.setId(context.getViewRoot().createUniqueId());
        if (value == null) {
            try {
                UISelectItem.class.getMethod("getValueExpression", String.class);
                selectItem.setValue((Object)new SelectItem(null, ""));
            }
            catch (NoSuchMethodException e) {
                selectItem.setItemValue((Object)"");
            }
        } else {
            selectItem.setItemValue(value);
        }
        if (label == null) {
            selectItem.setItemLabel(StringUtils.quietValueOf(value));
        } else if (FacesUtils.isExpression(label)) {
            selectItem.setValueBinding("itemLabel", application.createValueBinding(label));
        } else {
            String localizedLabel = metawidget.getLocalizedKey(StringUtils.camelCase(label));
            if (localizedLabel != null) {
                selectItem.setItemLabel(localizedLabel);
            } else {
                selectItem.setItemLabel(label);
            }
        }
        List children = component.getChildren();
        children.add(selectItem);
    }

    private void addSelectItems(UIComponent component, String binding, Map<String, String> attributes, UIMetawidget metawidget) {
        String itemValueBinding;
        String itemLabelBinding;
        if (binding == null) {
            return;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        Application application = context.getApplication();
        UIViewRoot viewRoot = context.getViewRoot();
        if (component instanceof HtmlSelectOneMenu && WidgetBuilderUtils.needsEmptyLookupItem(attributes)) {
            this.addSelectItem(component, null, null, metawidget);
        }
        UISelectItems selectItems = (UISelectItems)application.createComponent("javax.faces.SelectItems");
        selectItems.setId(viewRoot.createUniqueId());
        component.getChildren().add(selectItems);
        if (!FacesUtils.isExpression(binding)) {
            throw WidgetBuilderException.newException("Lookup '" + binding + "' is not of the form #{...}");
        }
        selectItems.setValueBinding("value", application.createValueBinding(binding));
        String var = attributes.get("faces-lookup-var");
        if (var != null) {
            selectItems.getAttributes().put("var", var);
        }
        if ((itemLabelBinding = attributes.get("faces-lookup-item-label")) != null) {
            selectItems.setValueBinding("itemLabel", application.createValueBinding(itemLabelBinding));
        }
        if ((itemValueBinding = attributes.get("faces-lookup-item-value")) != null) {
            selectItems.setValueBinding("itemValue", application.createValueBinding(itemValueBinding));
        }
    }
}

