/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.android;

import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.view.View;
import android.widget.TextView;
import org.metawidget.android.widget.AndroidMetawidget;

public final class AndroidUtils {
    private static final int[] VIEW_ATTRIBUTES = new int[]{16842965, 16842966, 16842967, 16842968, 16842969};
    private static final int[] TEXTVIEW_ATTRIBUTES = new int[]{16842904, 16842927};
    private static final int[] TEXTVIEW_ATTRIBUTES_SIZE = new int[]{16842901};
    private static final int BOGUS_DEFAULT = -1;

    public static void applyStyle(View view, int style, AndroidMetawidget metawidget) {
        int bottomPadding;
        int rightPadding;
        int topPadding;
        int leftPadding;
        if (style == 0) {
            return;
        }
        TypedArray attributes = metawidget.getContext().obtainStyledAttributes(style, VIEW_ATTRIBUTES);
        int padding = attributes.getDimensionPixelSize(0, -1);
        if (padding == -1) {
            leftPadding = attributes.getDimensionPixelSize(1, 0);
            topPadding = attributes.getDimensionPixelSize(2, 0);
            rightPadding = attributes.getDimensionPixelSize(3, 0);
            bottomPadding = attributes.getDimensionPixelSize(4, 0);
        } else {
            leftPadding = padding;
            topPadding = padding;
            rightPadding = padding;
            bottomPadding = padding;
        }
        view.setPadding(leftPadding, topPadding, rightPadding, bottomPadding);
        if (view instanceof TextView) {
            int textSize;
            int gravity;
            attributes = metawidget.getContext().obtainStyledAttributes(style, TEXTVIEW_ATTRIBUTES);
            TextView textView = (TextView)view;
            ColorStateList colors = attributes.getColorStateList(0);
            if (colors != null) {
                textView.setTextColor(colors);
            }
            if ((gravity = attributes.getInteger(1, -1)) != -1) {
                textView.setGravity(gravity);
            }
            if ((textSize = (attributes = metawidget.getContext().obtainStyledAttributes(style, TEXTVIEW_ATTRIBUTES_SIZE)).getDimensionPixelSize(0, -1)) != -1) {
                textView.setTextSize((float)textSize);
            }
        }
    }

    private AndroidUtils() {
    }
}

